/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ActiveDirectoryConfig;
import software.amazon.awssdk.services.workspaces.model.MicrosoftEntraConfig;
import software.amazon.awssdk.services.workspaces.model.SubnetIdsCopier;
import software.amazon.awssdk.services.workspaces.model.Tag;
import software.amazon.awssdk.services.workspaces.model.TagListCopier;
import software.amazon.awssdk.services.workspaces.model.Tenancy;
import software.amazon.awssdk.services.workspaces.model.UserIdentityType;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterWorkspaceDirectoryRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, RegisterWorkspaceDirectoryRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::directoryId)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::subnetIds)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_SELF_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableSelfService").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::enableSelfService)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::enableSelfService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSelfService").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::tenancyAsString)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::tags)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_DIRECTORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceDirectoryName").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::workspaceDirectoryName)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::workspaceDirectoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceDirectoryName").build()}).build();
    private static final SdkField<String> WORKSPACE_DIRECTORY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceDirectoryDescription").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::workspaceDirectoryDescription)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::workspaceDirectoryDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceDirectoryDescription").build()}).build();
    private static final SdkField<String> USER_IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserIdentityType").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::userIdentityTypeAsString)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::userIdentityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdentityType").build()}).build();
    private static final SdkField<String> IDC_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdcInstanceArn").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::idcInstanceArn)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::idcInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcInstanceArn").build()}).build();
    private static final SdkField<MicrosoftEntraConfig> MICROSOFT_ENTRA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MicrosoftEntraConfig").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::microsoftEntraConfig)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::microsoftEntraConfig)).constructor(MicrosoftEntraConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicrosoftEntraConfig").build()}).build();
    private static final SdkField<String> WORKSPACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceType").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::workspaceTypeAsString)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::workspaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceType").build()}).build();
    private static final SdkField<ActiveDirectoryConfig> ACTIVE_DIRECTORY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActiveDirectoryConfig").getter(RegisterWorkspaceDirectoryRequest.getter(RegisterWorkspaceDirectoryRequest::activeDirectoryConfig)).setter(RegisterWorkspaceDirectoryRequest.setter(Builder::activeDirectoryConfig)).constructor(ActiveDirectoryConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, SUBNET_IDS_FIELD, ENABLE_SELF_SERVICE_FIELD, TENANCY_FIELD, TAGS_FIELD, WORKSPACE_DIRECTORY_NAME_FIELD, WORKSPACE_DIRECTORY_DESCRIPTION_FIELD, USER_IDENTITY_TYPE_FIELD, IDC_INSTANCE_ARN_FIELD, MICROSOFT_ENTRA_CONFIG_FIELD, WORKSPACE_TYPE_FIELD, ACTIVE_DIRECTORY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterWorkspaceDirectoryRequest.memberNameToFieldInitializer();
    private final String directoryId;
    private final List<String> subnetIds;
    private final Boolean enableSelfService;
    private final String tenancy;
    private final List<Tag> tags;
    private final String workspaceDirectoryName;
    private final String workspaceDirectoryDescription;
    private final String userIdentityType;
    private final String idcInstanceArn;
    private final MicrosoftEntraConfig microsoftEntraConfig;
    private final String workspaceType;
    private final ActiveDirectoryConfig activeDirectoryConfig;

    private RegisterWorkspaceDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.subnetIds = builder.subnetIds;
        this.enableSelfService = builder.enableSelfService;
        this.tenancy = builder.tenancy;
        this.tags = builder.tags;
        this.workspaceDirectoryName = builder.workspaceDirectoryName;
        this.workspaceDirectoryDescription = builder.workspaceDirectoryDescription;
        this.userIdentityType = builder.userIdentityType;
        this.idcInstanceArn = builder.idcInstanceArn;
        this.microsoftEntraConfig = builder.microsoftEntraConfig;
        this.workspaceType = builder.workspaceType;
        this.activeDirectoryConfig = builder.activeDirectoryConfig;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final Boolean enableSelfService() {
        return this.enableSelfService;
    }

    public final Tenancy tenancy() {
        return Tenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String workspaceDirectoryName() {
        return this.workspaceDirectoryName;
    }

    public final String workspaceDirectoryDescription() {
        return this.workspaceDirectoryDescription;
    }

    public final UserIdentityType userIdentityType() {
        return UserIdentityType.fromValue(this.userIdentityType);
    }

    public final String userIdentityTypeAsString() {
        return this.userIdentityType;
    }

    public final String idcInstanceArn() {
        return this.idcInstanceArn;
    }

    public final MicrosoftEntraConfig microsoftEntraConfig() {
        return this.microsoftEntraConfig;
    }

    public final WorkspaceType workspaceType() {
        return WorkspaceType.fromValue(this.workspaceType);
    }

    public final String workspaceTypeAsString() {
        return this.workspaceType;
    }

    public final ActiveDirectoryConfig activeDirectoryConfig() {
        return this.activeDirectoryConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSelfService());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceDirectoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceDirectoryDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.idcInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.microsoftEntraConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterWorkspaceDirectoryRequest)) {
            return false;
        }
        RegisterWorkspaceDirectoryRequest other = (RegisterWorkspaceDirectoryRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.enableSelfService(), other.enableSelfService()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workspaceDirectoryName(), other.workspaceDirectoryName()) && Objects.equals(this.workspaceDirectoryDescription(), other.workspaceDirectoryDescription()) && Objects.equals(this.userIdentityTypeAsString(), other.userIdentityTypeAsString()) && Objects.equals(this.idcInstanceArn(), other.idcInstanceArn()) && Objects.equals(this.microsoftEntraConfig(), other.microsoftEntraConfig()) && Objects.equals(this.workspaceTypeAsString(), other.workspaceTypeAsString()) && Objects.equals(this.activeDirectoryConfig(), other.activeDirectoryConfig());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterWorkspaceDirectoryRequest").add("DirectoryId", (Object)this.directoryId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("EnableSelfService", (Object)this.enableSelfService()).add("Tenancy", (Object)this.tenancyAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("WorkspaceDirectoryName", (Object)this.workspaceDirectoryName()).add("WorkspaceDirectoryDescription", (Object)this.workspaceDirectoryDescription()).add("UserIdentityType", (Object)this.userIdentityTypeAsString()).add("IdcInstanceArn", (Object)this.idcInstanceArn()).add("MicrosoftEntraConfig", (Object)this.microsoftEntraConfig()).add("WorkspaceType", (Object)this.workspaceTypeAsString()).add("ActiveDirectoryConfig", (Object)this.activeDirectoryConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "EnableSelfService": {
                return Optional.ofNullable(clazz.cast(this.enableSelfService()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WorkspaceDirectoryName": {
                return Optional.ofNullable(clazz.cast(this.workspaceDirectoryName()));
            }
            case "WorkspaceDirectoryDescription": {
                return Optional.ofNullable(clazz.cast(this.workspaceDirectoryDescription()));
            }
            case "UserIdentityType": {
                return Optional.ofNullable(clazz.cast(this.userIdentityTypeAsString()));
            }
            case "IdcInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.idcInstanceArn()));
            }
            case "MicrosoftEntraConfig": {
                return Optional.ofNullable(clazz.cast(this.microsoftEntraConfig()));
            }
            case "WorkspaceType": {
                return Optional.ofNullable(clazz.cast(this.workspaceTypeAsString()));
            }
            case "ActiveDirectoryConfig": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("EnableSelfService", ENABLE_SELF_SERVICE_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("WorkspaceDirectoryName", WORKSPACE_DIRECTORY_NAME_FIELD);
        map.put("WorkspaceDirectoryDescription", WORKSPACE_DIRECTORY_DESCRIPTION_FIELD);
        map.put("UserIdentityType", USER_IDENTITY_TYPE_FIELD);
        map.put("IdcInstanceArn", IDC_INSTANCE_ARN_FIELD);
        map.put("MicrosoftEntraConfig", MICROSOFT_ENTRA_CONFIG_FIELD);
        map.put("WorkspaceType", WORKSPACE_TYPE_FIELD);
        map.put("ActiveDirectoryConfig", ACTIVE_DIRECTORY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterWorkspaceDirectoryRequest, T> g) {
        return obj -> g.apply((RegisterWorkspaceDirectoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableSelfService;
        private String tenancy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String workspaceDirectoryName;
        private String workspaceDirectoryDescription;
        private String userIdentityType;
        private String idcInstanceArn;
        private MicrosoftEntraConfig microsoftEntraConfig;
        private String workspaceType;
        private ActiveDirectoryConfig activeDirectoryConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterWorkspaceDirectoryRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.subnetIds(model.subnetIds);
            this.enableSelfService(model.enableSelfService);
            this.tenancy(model.tenancy);
            this.tags(model.tags);
            this.workspaceDirectoryName(model.workspaceDirectoryName);
            this.workspaceDirectoryDescription(model.workspaceDirectoryDescription);
            this.userIdentityType(model.userIdentityType);
            this.idcInstanceArn(model.idcInstanceArn);
            this.microsoftEntraConfig(model.microsoftEntraConfig);
            this.workspaceType(model.workspaceType);
            this.activeDirectoryConfig(model.activeDirectoryConfig);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Boolean getEnableSelfService() {
            return this.enableSelfService;
        }

        public final void setEnableSelfService(Boolean enableSelfService) {
            this.enableSelfService = enableSelfService;
        }

        @Override
        public final Builder enableSelfService(Boolean enableSelfService) {
            this.enableSelfService = enableSelfService;
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkspaceDirectoryName() {
            return this.workspaceDirectoryName;
        }

        public final void setWorkspaceDirectoryName(String workspaceDirectoryName) {
            this.workspaceDirectoryName = workspaceDirectoryName;
        }

        @Override
        public final Builder workspaceDirectoryName(String workspaceDirectoryName) {
            this.workspaceDirectoryName = workspaceDirectoryName;
            return this;
        }

        public final String getWorkspaceDirectoryDescription() {
            return this.workspaceDirectoryDescription;
        }

        public final void setWorkspaceDirectoryDescription(String workspaceDirectoryDescription) {
            this.workspaceDirectoryDescription = workspaceDirectoryDescription;
        }

        @Override
        public final Builder workspaceDirectoryDescription(String workspaceDirectoryDescription) {
            this.workspaceDirectoryDescription = workspaceDirectoryDescription;
            return this;
        }

        public final String getUserIdentityType() {
            return this.userIdentityType;
        }

        public final void setUserIdentityType(String userIdentityType) {
            this.userIdentityType = userIdentityType;
        }

        @Override
        public final Builder userIdentityType(String userIdentityType) {
            this.userIdentityType = userIdentityType;
            return this;
        }

        @Override
        public final Builder userIdentityType(UserIdentityType userIdentityType) {
            this.userIdentityType(userIdentityType == null ? null : userIdentityType.toString());
            return this;
        }

        public final String getIdcInstanceArn() {
            return this.idcInstanceArn;
        }

        public final void setIdcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
        }

        @Override
        public final Builder idcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
            return this;
        }

        public final MicrosoftEntraConfig.Builder getMicrosoftEntraConfig() {
            return this.microsoftEntraConfig != null ? this.microsoftEntraConfig.toBuilder() : null;
        }

        public final void setMicrosoftEntraConfig(MicrosoftEntraConfig.BuilderImpl microsoftEntraConfig) {
            this.microsoftEntraConfig = microsoftEntraConfig != null ? microsoftEntraConfig.build() : null;
        }

        @Override
        public final Builder microsoftEntraConfig(MicrosoftEntraConfig microsoftEntraConfig) {
            this.microsoftEntraConfig = microsoftEntraConfig;
            return this;
        }

        public final String getWorkspaceType() {
            return this.workspaceType;
        }

        public final void setWorkspaceType(String workspaceType) {
            this.workspaceType = workspaceType;
        }

        @Override
        public final Builder workspaceType(String workspaceType) {
            this.workspaceType = workspaceType;
            return this;
        }

        @Override
        public final Builder workspaceType(WorkspaceType workspaceType) {
            this.workspaceType(workspaceType == null ? null : workspaceType.toString());
            return this;
        }

        public final ActiveDirectoryConfig.Builder getActiveDirectoryConfig() {
            return this.activeDirectoryConfig != null ? this.activeDirectoryConfig.toBuilder() : null;
        }

        public final void setActiveDirectoryConfig(ActiveDirectoryConfig.BuilderImpl activeDirectoryConfig) {
            this.activeDirectoryConfig = activeDirectoryConfig != null ? activeDirectoryConfig.build() : null;
        }

        @Override
        public final Builder activeDirectoryConfig(ActiveDirectoryConfig activeDirectoryConfig) {
            this.activeDirectoryConfig = activeDirectoryConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterWorkspaceDirectoryRequest build() {
            return new RegisterWorkspaceDirectoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterWorkspaceDirectoryRequest> {
        public Builder directoryId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder enableSelfService(Boolean var1);

        public Builder tenancy(String var1);

        public Builder tenancy(Tenancy var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder workspaceDirectoryName(String var1);

        public Builder workspaceDirectoryDescription(String var1);

        public Builder userIdentityType(String var1);

        public Builder userIdentityType(UserIdentityType var1);

        public Builder idcInstanceArn(String var1);

        public Builder microsoftEntraConfig(MicrosoftEntraConfig var1);

        default public Builder microsoftEntraConfig(Consumer<MicrosoftEntraConfig.Builder> microsoftEntraConfig) {
            return this.microsoftEntraConfig((MicrosoftEntraConfig)((MicrosoftEntraConfig.Builder)MicrosoftEntraConfig.builder().applyMutation(microsoftEntraConfig)).build());
        }

        public Builder workspaceType(String var1);

        public Builder workspaceType(WorkspaceType var1);

        public Builder activeDirectoryConfig(ActiveDirectoryConfig var1);

        default public Builder activeDirectoryConfig(Consumer<ActiveDirectoryConfig.Builder> activeDirectoryConfig) {
            return this.activeDirectoryConfig((ActiveDirectoryConfig)((ActiveDirectoryConfig.Builder)ActiveDirectoryConfig.builder().applyMutation(activeDirectoryConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

