/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.DataReplicationSettings;
import software.amazon.awssdk.services.workspaces.model.ModificationState;
import software.amazon.awssdk.services.workspaces.model.ModificationStateListCopier;
import software.amazon.awssdk.services.workspaces.model.RelatedWorkspaceProperties;
import software.amazon.awssdk.services.workspaces.model.RelatedWorkspacesCopier;
import software.amazon.awssdk.services.workspaces.model.StandbyWorkspacesProperties;
import software.amazon.awssdk.services.workspaces.model.StandbyWorkspacesPropertiesListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkspaceProperties;
import software.amazon.awssdk.services.workspaces.model.WorkspaceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workspace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workspace> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceId").getter(Workspace.getter(Workspace::workspaceId)).setter(Workspace.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(Workspace.getter(Workspace::directoryId)).setter(Workspace.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(Workspace.getter(Workspace::userName)).setter(Workspace.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(Workspace.getter(Workspace::ipAddress)).setter(Workspace.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Workspace.getter(Workspace::stateAsString)).setter(Workspace.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BundleId").getter(Workspace.getter(Workspace::bundleId)).setter(Workspace.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(Workspace.getter(Workspace::subnetId)).setter(Workspace.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(Workspace.getter(Workspace::errorMessage)).setter(Workspace.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(Workspace.getter(Workspace::errorCode)).setter(Workspace.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputerName").getter(Workspace.getter(Workspace::computerName)).setter(Workspace.setter(Builder::computerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()}).build();
    private static final SdkField<String> VOLUME_ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeEncryptionKey").getter(Workspace.getter(Workspace::volumeEncryptionKey)).setter(Workspace.setter(Builder::volumeEncryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeEncryptionKey").build()}).build();
    private static final SdkField<Boolean> USER_VOLUME_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserVolumeEncryptionEnabled").getter(Workspace.getter(Workspace::userVolumeEncryptionEnabled)).setter(Workspace.setter(Builder::userVolumeEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserVolumeEncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RootVolumeEncryptionEnabled").getter(Workspace.getter(Workspace::rootVolumeEncryptionEnabled)).setter(Workspace.setter(Builder::rootVolumeEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeEncryptionEnabled").build()}).build();
    private static final SdkField<String> WORKSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceName").getter(Workspace.getter(Workspace::workspaceName)).setter(Workspace.setter(Builder::workspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceName").build()}).build();
    private static final SdkField<WorkspaceProperties> WORKSPACE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkspaceProperties").getter(Workspace.getter(Workspace::workspaceProperties)).setter(Workspace.setter(Builder::workspaceProperties)).constructor(WorkspaceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceProperties").build()}).build();
    private static final SdkField<List<ModificationState>> MODIFICATION_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModificationStates").getter(Workspace.getter(Workspace::modificationStates)).setter(Workspace.setter(Builder::modificationStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModificationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RelatedWorkspaceProperties>> RELATED_WORKSPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedWorkspaces").getter(Workspace.getter(Workspace::relatedWorkspaces)).setter(Workspace.setter(Builder::relatedWorkspaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedWorkspaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedWorkspaceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataReplicationSettings> DATA_REPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataReplicationSettings").getter(Workspace.getter(Workspace::dataReplicationSettings)).setter(Workspace.setter(Builder::dataReplicationSettings)).constructor(DataReplicationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataReplicationSettings").build()}).build();
    private static final SdkField<List<StandbyWorkspacesProperties>> STANDBY_WORKSPACES_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandbyWorkspacesProperties").getter(Workspace.getter(Workspace::standbyWorkspacesProperties)).setter(Workspace.setter(Builder::standbyWorkspacesProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandbyWorkspacesProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StandbyWorkspacesProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, DIRECTORY_ID_FIELD, USER_NAME_FIELD, IP_ADDRESS_FIELD, STATE_FIELD, BUNDLE_ID_FIELD, SUBNET_ID_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, COMPUTER_NAME_FIELD, VOLUME_ENCRYPTION_KEY_FIELD, USER_VOLUME_ENCRYPTION_ENABLED_FIELD, ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD, WORKSPACE_NAME_FIELD, WORKSPACE_PROPERTIES_FIELD, MODIFICATION_STATES_FIELD, RELATED_WORKSPACES_FIELD, DATA_REPLICATION_SETTINGS_FIELD, STANDBY_WORKSPACES_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Workspace.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workspaceId;
    private final String directoryId;
    private final String userName;
    private final String ipAddress;
    private final String state;
    private final String bundleId;
    private final String subnetId;
    private final String errorMessage;
    private final String errorCode;
    private final String computerName;
    private final String volumeEncryptionKey;
    private final Boolean userVolumeEncryptionEnabled;
    private final Boolean rootVolumeEncryptionEnabled;
    private final String workspaceName;
    private final WorkspaceProperties workspaceProperties;
    private final List<ModificationState> modificationStates;
    private final List<RelatedWorkspaceProperties> relatedWorkspaces;
    private final DataReplicationSettings dataReplicationSettings;
    private final List<StandbyWorkspacesProperties> standbyWorkspacesProperties;

    private Workspace(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.ipAddress = builder.ipAddress;
        this.state = builder.state;
        this.bundleId = builder.bundleId;
        this.subnetId = builder.subnetId;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.computerName = builder.computerName;
        this.volumeEncryptionKey = builder.volumeEncryptionKey;
        this.userVolumeEncryptionEnabled = builder.userVolumeEncryptionEnabled;
        this.rootVolumeEncryptionEnabled = builder.rootVolumeEncryptionEnabled;
        this.workspaceName = builder.workspaceName;
        this.workspaceProperties = builder.workspaceProperties;
        this.modificationStates = builder.modificationStates;
        this.relatedWorkspaces = builder.relatedWorkspaces;
        this.dataReplicationSettings = builder.dataReplicationSettings;
        this.standbyWorkspacesProperties = builder.standbyWorkspacesProperties;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final WorkspaceState state() {
        return WorkspaceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String computerName() {
        return this.computerName;
    }

    public final String volumeEncryptionKey() {
        return this.volumeEncryptionKey;
    }

    public final Boolean userVolumeEncryptionEnabled() {
        return this.userVolumeEncryptionEnabled;
    }

    public final Boolean rootVolumeEncryptionEnabled() {
        return this.rootVolumeEncryptionEnabled;
    }

    public final String workspaceName() {
        return this.workspaceName;
    }

    public final WorkspaceProperties workspaceProperties() {
        return this.workspaceProperties;
    }

    public final boolean hasModificationStates() {
        return this.modificationStates != null && !(this.modificationStates instanceof SdkAutoConstructList);
    }

    public final List<ModificationState> modificationStates() {
        return this.modificationStates;
    }

    public final boolean hasRelatedWorkspaces() {
        return this.relatedWorkspaces != null && !(this.relatedWorkspaces instanceof SdkAutoConstructList);
    }

    public final List<RelatedWorkspaceProperties> relatedWorkspaces() {
        return this.relatedWorkspaces;
    }

    public final DataReplicationSettings dataReplicationSettings() {
        return this.dataReplicationSettings;
    }

    public final boolean hasStandbyWorkspacesProperties() {
        return this.standbyWorkspacesProperties != null && !(this.standbyWorkspacesProperties instanceof SdkAutoConstructList);
    }

    public final List<StandbyWorkspacesProperties> standbyWorkspacesProperties() {
        return this.standbyWorkspacesProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.computerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.userVolumeEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolumeEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModificationStates() ? this.modificationStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedWorkspaces() ? this.relatedWorkspaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandbyWorkspacesProperties() ? this.standbyWorkspacesProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workspace)) {
            return false;
        }
        Workspace other = (Workspace)obj;
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.computerName(), other.computerName()) && Objects.equals(this.volumeEncryptionKey(), other.volumeEncryptionKey()) && Objects.equals(this.userVolumeEncryptionEnabled(), other.userVolumeEncryptionEnabled()) && Objects.equals(this.rootVolumeEncryptionEnabled(), other.rootVolumeEncryptionEnabled()) && Objects.equals(this.workspaceName(), other.workspaceName()) && Objects.equals(this.workspaceProperties(), other.workspaceProperties()) && this.hasModificationStates() == other.hasModificationStates() && Objects.equals(this.modificationStates(), other.modificationStates()) && this.hasRelatedWorkspaces() == other.hasRelatedWorkspaces() && Objects.equals(this.relatedWorkspaces(), other.relatedWorkspaces()) && Objects.equals(this.dataReplicationSettings(), other.dataReplicationSettings()) && this.hasStandbyWorkspacesProperties() == other.hasStandbyWorkspacesProperties() && Objects.equals(this.standbyWorkspacesProperties(), other.standbyWorkspacesProperties());
    }

    public final String toString() {
        return ToString.builder((String)"Workspace").add("WorkspaceId", (Object)this.workspaceId()).add("DirectoryId", (Object)this.directoryId()).add("UserName", (Object)this.userName()).add("IpAddress", (Object)this.ipAddress()).add("State", (Object)this.stateAsString()).add("BundleId", (Object)this.bundleId()).add("SubnetId", (Object)this.subnetId()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorCode", (Object)this.errorCode()).add("ComputerName", (Object)this.computerName()).add("VolumeEncryptionKey", (Object)this.volumeEncryptionKey()).add("UserVolumeEncryptionEnabled", (Object)this.userVolumeEncryptionEnabled()).add("RootVolumeEncryptionEnabled", (Object)this.rootVolumeEncryptionEnabled()).add("WorkspaceName", (Object)this.workspaceName()).add("WorkspaceProperties", (Object)this.workspaceProperties()).add("ModificationStates", this.hasModificationStates() ? this.modificationStates() : null).add("RelatedWorkspaces", this.hasRelatedWorkspaces() ? this.relatedWorkspaces() : null).add("DataReplicationSettings", (Object)this.dataReplicationSettings()).add("StandbyWorkspacesProperties", this.hasStandbyWorkspacesProperties() ? this.standbyWorkspacesProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "BundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ComputerName": {
                return Optional.ofNullable(clazz.cast(this.computerName()));
            }
            case "VolumeEncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.volumeEncryptionKey()));
            }
            case "UserVolumeEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.userVolumeEncryptionEnabled()));
            }
            case "RootVolumeEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.rootVolumeEncryptionEnabled()));
            }
            case "WorkspaceName": {
                return Optional.ofNullable(clazz.cast(this.workspaceName()));
            }
            case "WorkspaceProperties": {
                return Optional.ofNullable(clazz.cast(this.workspaceProperties()));
            }
            case "ModificationStates": {
                return Optional.ofNullable(clazz.cast(this.modificationStates()));
            }
            case "RelatedWorkspaces": {
                return Optional.ofNullable(clazz.cast(this.relatedWorkspaces()));
            }
            case "DataReplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationSettings()));
            }
            case "StandbyWorkspacesProperties": {
                return Optional.ofNullable(clazz.cast(this.standbyWorkspacesProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("BundleId", BUNDLE_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ComputerName", COMPUTER_NAME_FIELD);
        map.put("VolumeEncryptionKey", VOLUME_ENCRYPTION_KEY_FIELD);
        map.put("UserVolumeEncryptionEnabled", USER_VOLUME_ENCRYPTION_ENABLED_FIELD);
        map.put("RootVolumeEncryptionEnabled", ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD);
        map.put("WorkspaceName", WORKSPACE_NAME_FIELD);
        map.put("WorkspaceProperties", WORKSPACE_PROPERTIES_FIELD);
        map.put("ModificationStates", MODIFICATION_STATES_FIELD);
        map.put("RelatedWorkspaces", RELATED_WORKSPACES_FIELD);
        map.put("DataReplicationSettings", DATA_REPLICATION_SETTINGS_FIELD);
        map.put("StandbyWorkspacesProperties", STANDBY_WORKSPACES_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Workspace, T> g) {
        return obj -> g.apply((Workspace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workspaceId;
        private String directoryId;
        private String userName;
        private String ipAddress;
        private String state;
        private String bundleId;
        private String subnetId;
        private String errorMessage;
        private String errorCode;
        private String computerName;
        private String volumeEncryptionKey;
        private Boolean userVolumeEncryptionEnabled;
        private Boolean rootVolumeEncryptionEnabled;
        private String workspaceName;
        private WorkspaceProperties workspaceProperties;
        private List<ModificationState> modificationStates = DefaultSdkAutoConstructList.getInstance();
        private List<RelatedWorkspaceProperties> relatedWorkspaces = DefaultSdkAutoConstructList.getInstance();
        private DataReplicationSettings dataReplicationSettings;
        private List<StandbyWorkspacesProperties> standbyWorkspacesProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Workspace model) {
            this.workspaceId(model.workspaceId);
            this.directoryId(model.directoryId);
            this.userName(model.userName);
            this.ipAddress(model.ipAddress);
            this.state(model.state);
            this.bundleId(model.bundleId);
            this.subnetId(model.subnetId);
            this.errorMessage(model.errorMessage);
            this.errorCode(model.errorCode);
            this.computerName(model.computerName);
            this.volumeEncryptionKey(model.volumeEncryptionKey);
            this.userVolumeEncryptionEnabled(model.userVolumeEncryptionEnabled);
            this.rootVolumeEncryptionEnabled(model.rootVolumeEncryptionEnabled);
            this.workspaceName(model.workspaceName);
            this.workspaceProperties(model.workspaceProperties);
            this.modificationStates(model.modificationStates);
            this.relatedWorkspaces(model.relatedWorkspaces);
            this.dataReplicationSettings(model.dataReplicationSettings);
            this.standbyWorkspacesProperties(model.standbyWorkspacesProperties);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getComputerName() {
            return this.computerName;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final String getVolumeEncryptionKey() {
            return this.volumeEncryptionKey;
        }

        public final void setVolumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
        }

        @Override
        public final Builder volumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        public final Boolean getUserVolumeEncryptionEnabled() {
            return this.userVolumeEncryptionEnabled;
        }

        public final void setUserVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
        }

        @Override
        public final Builder userVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
            return this;
        }

        public final Boolean getRootVolumeEncryptionEnabled() {
            return this.rootVolumeEncryptionEnabled;
        }

        public final void setRootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
        }

        @Override
        public final Builder rootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
            return this;
        }

        public final String getWorkspaceName() {
            return this.workspaceName;
        }

        public final void setWorkspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
        }

        @Override
        public final Builder workspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
            return this;
        }

        public final WorkspaceProperties.Builder getWorkspaceProperties() {
            return this.workspaceProperties != null ? this.workspaceProperties.toBuilder() : null;
        }

        public final void setWorkspaceProperties(WorkspaceProperties.BuilderImpl workspaceProperties) {
            this.workspaceProperties = workspaceProperties != null ? workspaceProperties.build() : null;
        }

        @Override
        public final Builder workspaceProperties(WorkspaceProperties workspaceProperties) {
            this.workspaceProperties = workspaceProperties;
            return this;
        }

        public final List<ModificationState.Builder> getModificationStates() {
            List<ModificationState.Builder> result = ModificationStateListCopier.copyToBuilder(this.modificationStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModificationStates(Collection<ModificationState.BuilderImpl> modificationStates) {
            this.modificationStates = ModificationStateListCopier.copyFromBuilder(modificationStates);
        }

        @Override
        public final Builder modificationStates(Collection<ModificationState> modificationStates) {
            this.modificationStates = ModificationStateListCopier.copy(modificationStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationStates(ModificationState ... modificationStates) {
            this.modificationStates(Arrays.asList(modificationStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationStates(Consumer<ModificationState.Builder> ... modificationStates) {
            this.modificationStates(Stream.of(modificationStates).map(c -> (ModificationState)((ModificationState.Builder)ModificationState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RelatedWorkspaceProperties.Builder> getRelatedWorkspaces() {
            List<RelatedWorkspaceProperties.Builder> result = RelatedWorkspacesCopier.copyToBuilder(this.relatedWorkspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedWorkspaces(Collection<RelatedWorkspaceProperties.BuilderImpl> relatedWorkspaces) {
            this.relatedWorkspaces = RelatedWorkspacesCopier.copyFromBuilder(relatedWorkspaces);
        }

        @Override
        public final Builder relatedWorkspaces(Collection<RelatedWorkspaceProperties> relatedWorkspaces) {
            this.relatedWorkspaces = RelatedWorkspacesCopier.copy(relatedWorkspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedWorkspaces(RelatedWorkspaceProperties ... relatedWorkspaces) {
            this.relatedWorkspaces(Arrays.asList(relatedWorkspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedWorkspaces(Consumer<RelatedWorkspaceProperties.Builder> ... relatedWorkspaces) {
            this.relatedWorkspaces(Stream.of(relatedWorkspaces).map(c -> (RelatedWorkspaceProperties)((RelatedWorkspaceProperties.Builder)RelatedWorkspaceProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataReplicationSettings.Builder getDataReplicationSettings() {
            return this.dataReplicationSettings != null ? this.dataReplicationSettings.toBuilder() : null;
        }

        public final void setDataReplicationSettings(DataReplicationSettings.BuilderImpl dataReplicationSettings) {
            this.dataReplicationSettings = dataReplicationSettings != null ? dataReplicationSettings.build() : null;
        }

        @Override
        public final Builder dataReplicationSettings(DataReplicationSettings dataReplicationSettings) {
            this.dataReplicationSettings = dataReplicationSettings;
            return this;
        }

        public final List<StandbyWorkspacesProperties.Builder> getStandbyWorkspacesProperties() {
            List<StandbyWorkspacesProperties.Builder> result = StandbyWorkspacesPropertiesListCopier.copyToBuilder(this.standbyWorkspacesProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStandbyWorkspacesProperties(Collection<StandbyWorkspacesProperties.BuilderImpl> standbyWorkspacesProperties) {
            this.standbyWorkspacesProperties = StandbyWorkspacesPropertiesListCopier.copyFromBuilder(standbyWorkspacesProperties);
        }

        @Override
        public final Builder standbyWorkspacesProperties(Collection<StandbyWorkspacesProperties> standbyWorkspacesProperties) {
            this.standbyWorkspacesProperties = StandbyWorkspacesPropertiesListCopier.copy(standbyWorkspacesProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standbyWorkspacesProperties(StandbyWorkspacesProperties ... standbyWorkspacesProperties) {
            this.standbyWorkspacesProperties(Arrays.asList(standbyWorkspacesProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standbyWorkspacesProperties(Consumer<StandbyWorkspacesProperties.Builder> ... standbyWorkspacesProperties) {
            this.standbyWorkspacesProperties(Stream.of(standbyWorkspacesProperties).map(c -> (StandbyWorkspacesProperties)((StandbyWorkspacesProperties.Builder)StandbyWorkspacesProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Workspace build() {
            return new Workspace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workspace> {
        public Builder workspaceId(String var1);

        public Builder directoryId(String var1);

        public Builder userName(String var1);

        public Builder ipAddress(String var1);

        public Builder state(String var1);

        public Builder state(WorkspaceState var1);

        public Builder bundleId(String var1);

        public Builder subnetId(String var1);

        public Builder errorMessage(String var1);

        public Builder errorCode(String var1);

        public Builder computerName(String var1);

        public Builder volumeEncryptionKey(String var1);

        public Builder userVolumeEncryptionEnabled(Boolean var1);

        public Builder rootVolumeEncryptionEnabled(Boolean var1);

        public Builder workspaceName(String var1);

        public Builder workspaceProperties(WorkspaceProperties var1);

        default public Builder workspaceProperties(Consumer<WorkspaceProperties.Builder> workspaceProperties) {
            return this.workspaceProperties((WorkspaceProperties)((WorkspaceProperties.Builder)WorkspaceProperties.builder().applyMutation(workspaceProperties)).build());
        }

        public Builder modificationStates(Collection<ModificationState> var1);

        public Builder modificationStates(ModificationState ... var1);

        public Builder modificationStates(Consumer<ModificationState.Builder> ... var1);

        public Builder relatedWorkspaces(Collection<RelatedWorkspaceProperties> var1);

        public Builder relatedWorkspaces(RelatedWorkspaceProperties ... var1);

        public Builder relatedWorkspaces(Consumer<RelatedWorkspaceProperties.Builder> ... var1);

        public Builder dataReplicationSettings(DataReplicationSettings var1);

        default public Builder dataReplicationSettings(Consumer<DataReplicationSettings.Builder> dataReplicationSettings) {
            return this.dataReplicationSettings((DataReplicationSettings)((DataReplicationSettings.Builder)DataReplicationSettings.builder().applyMutation(dataReplicationSettings)).build());
        }

        public Builder standbyWorkspacesProperties(Collection<StandbyWorkspacesProperties> var1);

        public Builder standbyWorkspacesProperties(StandbyWorkspacesProperties ... var1);

        public Builder standbyWorkspacesProperties(Consumer<StandbyWorkspacesProperties.Builder> ... var1);
    }
}

