/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssociationStatus {
    NOT_ASSOCIATED("NOT_ASSOCIATED"),
    ASSOCIATED_WITH_OWNER_ACCOUNT("ASSOCIATED_WITH_OWNER_ACCOUNT"),
    ASSOCIATED_WITH_SHARED_ACCOUNT("ASSOCIATED_WITH_SHARED_ACCOUNT"),
    PENDING_ASSOCIATION("PENDING_ASSOCIATION"),
    PENDING_DISASSOCIATION("PENDING_DISASSOCIATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssociationStatus> VALUE_MAP;
    private final String value;

    private AssociationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssociationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssociationStatus> knownValues() {
        EnumSet<AssociationStatus> knownValues = EnumSet.allOf(AssociationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssociationStatus.class, AssociationStatus::toString);
    }
}

