/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ImageAssociatedResourceType;
import software.amazon.awssdk.services.workspaces.model.ImageAssociatedResourceTypeListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageAssociationsRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeImageAssociationsRequest> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(DescribeImageAssociationsRequest.getter(DescribeImageAssociationsRequest::imageId)).setter(DescribeImageAssociationsRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedResourceTypes").getter(DescribeImageAssociationsRequest.getter(DescribeImageAssociationsRequest::associatedResourceTypesAsStrings)).setter(DescribeImageAssociationsRequest.setter(Builder::associatedResourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, ASSOCIATED_RESOURCE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImageAssociationsRequest.memberNameToFieldInitializer();
    private final String imageId;
    private final List<String> associatedResourceTypes;

    private DescribeImageAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.associatedResourceTypes = builder.associatedResourceTypes;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final List<ImageAssociatedResourceType> associatedResourceTypes() {
        return ImageAssociatedResourceTypeListCopier.copyStringToEnum(this.associatedResourceTypes);
    }

    public final boolean hasAssociatedResourceTypes() {
        return this.associatedResourceTypes != null && !(this.associatedResourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> associatedResourceTypesAsStrings() {
        return this.associatedResourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResourceTypes() ? this.associatedResourceTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageAssociationsRequest)) {
            return false;
        }
        DescribeImageAssociationsRequest other = (DescribeImageAssociationsRequest)((Object)obj);
        return Objects.equals(this.imageId(), other.imageId()) && this.hasAssociatedResourceTypes() == other.hasAssociatedResourceTypes() && Objects.equals(this.associatedResourceTypesAsStrings(), other.associatedResourceTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageAssociationsRequest").add("ImageId", (Object)this.imageId()).add("AssociatedResourceTypes", this.hasAssociatedResourceTypes() ? this.associatedResourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "AssociatedResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("AssociatedResourceTypes", ASSOCIATED_RESOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageAssociationsRequest, T> g) {
        return obj -> g.apply((DescribeImageAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String imageId;
        private List<String> associatedResourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageAssociationsRequest model) {
            super(model);
            this.imageId(model.imageId);
            this.associatedResourceTypesWithStrings(model.associatedResourceTypes);
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Collection<String> getAssociatedResourceTypes() {
            if (this.associatedResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedResourceTypes;
        }

        public final void setAssociatedResourceTypes(Collection<String> associatedResourceTypes) {
            this.associatedResourceTypes = ImageAssociatedResourceTypeListCopier.copy(associatedResourceTypes);
        }

        @Override
        public final Builder associatedResourceTypesWithStrings(Collection<String> associatedResourceTypes) {
            this.associatedResourceTypes = ImageAssociatedResourceTypeListCopier.copy(associatedResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceTypesWithStrings(String ... associatedResourceTypes) {
            this.associatedResourceTypesWithStrings(Arrays.asList(associatedResourceTypes));
            return this;
        }

        @Override
        public final Builder associatedResourceTypes(Collection<ImageAssociatedResourceType> associatedResourceTypes) {
            this.associatedResourceTypes = ImageAssociatedResourceTypeListCopier.copyEnumToString(associatedResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceTypes(ImageAssociatedResourceType ... associatedResourceTypes) {
            this.associatedResourceTypes(Arrays.asList(associatedResourceTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImageAssociationsRequest build() {
            return new DescribeImageAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageAssociationsRequest> {
        public Builder imageId(String var1);

        public Builder associatedResourceTypesWithStrings(Collection<String> var1);

        public Builder associatedResourceTypesWithStrings(String ... var1);

        public Builder associatedResourceTypes(Collection<ImageAssociatedResourceType> var1);

        public Builder associatedResourceTypes(ImageAssociatedResourceType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

