/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspacesPool;
import software.amazon.awssdk.services.workspaces.model.WorkspacesPoolsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspacesPoolsResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeWorkspacesPoolsResponse> {
    private static final SdkField<List<WorkspacesPool>> WORKSPACES_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkspacesPools").getter(DescribeWorkspacesPoolsResponse.getter(DescribeWorkspacesPoolsResponse::workspacesPools)).setter(DescribeWorkspacesPoolsResponse.setter(Builder::workspacesPools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspacesPools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspacesPool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspacesPoolsResponse.getter(DescribeWorkspacesPoolsResponse::nextToken)).setter(DescribeWorkspacesPoolsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACES_POOLS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeWorkspacesPoolsResponse.memberNameToFieldInitializer();
    private final List<WorkspacesPool> workspacesPools;
    private final String nextToken;

    private DescribeWorkspacesPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.workspacesPools = builder.workspacesPools;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorkspacesPools() {
        return this.workspacesPools != null && !(this.workspacesPools instanceof SdkAutoConstructList);
    }

    public final List<WorkspacesPool> workspacesPools() {
        return this.workspacesPools;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspacesPools() ? this.workspacesPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesPoolsResponse)) {
            return false;
        }
        DescribeWorkspacesPoolsResponse other = (DescribeWorkspacesPoolsResponse)((Object)obj);
        return this.hasWorkspacesPools() == other.hasWorkspacesPools() && Objects.equals(this.workspacesPools(), other.workspacesPools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspacesPoolsResponse").add("WorkspacesPools", this.hasWorkspacesPools() ? this.workspacesPools() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspacesPools": {
                return Optional.ofNullable(clazz.cast(this.workspacesPools()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkspacesPools", WORKSPACES_POOLS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesPoolsResponse, T> g) {
        return obj -> g.apply((DescribeWorkspacesPoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<WorkspacesPool> workspacesPools = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesPoolsResponse model) {
            super(model);
            this.workspacesPools(model.workspacesPools);
            this.nextToken(model.nextToken);
        }

        public final List<WorkspacesPool.Builder> getWorkspacesPools() {
            List<WorkspacesPool.Builder> result = WorkspacesPoolsCopier.copyToBuilder(this.workspacesPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspacesPools(Collection<WorkspacesPool.BuilderImpl> workspacesPools) {
            this.workspacesPools = WorkspacesPoolsCopier.copyFromBuilder(workspacesPools);
        }

        @Override
        public final Builder workspacesPools(Collection<WorkspacesPool> workspacesPools) {
            this.workspacesPools = WorkspacesPoolsCopier.copy(workspacesPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspacesPools(WorkspacesPool ... workspacesPools) {
            this.workspacesPools(Arrays.asList(workspacesPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspacesPools(Consumer<WorkspacesPool.Builder> ... workspacesPools) {
            this.workspacesPools(Stream.of(workspacesPools).map(c -> (WorkspacesPool)((WorkspacesPool.Builder)WorkspacesPool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeWorkspacesPoolsResponse build() {
            return new DescribeWorkspacesPoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspacesPoolsResponse> {
        public Builder workspacesPools(Collection<WorkspacesPool> var1);

        public Builder workspacesPools(WorkspacesPool ... var1);

        public Builder workspacesPools(Consumer<WorkspacesPool.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

