/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.RebootRequest;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspaceRequestsCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RebootWorkspacesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, RebootWorkspacesRequest> {
    private static final SdkField<List<RebootRequest>> REBOOT_WORKSPACE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RebootWorkspaceRequests").getter(RebootWorkspacesRequest.getter(RebootWorkspacesRequest::rebootWorkspaceRequests)).setter(RebootWorkspacesRequest.setter(Builder::rebootWorkspaceRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebootWorkspaceRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RebootRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REBOOT_WORKSPACE_REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RebootWorkspacesRequest.memberNameToFieldInitializer();
    private final List<RebootRequest> rebootWorkspaceRequests;

    private RebootWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.rebootWorkspaceRequests = builder.rebootWorkspaceRequests;
    }

    public final boolean hasRebootWorkspaceRequests() {
        return this.rebootWorkspaceRequests != null && !(this.rebootWorkspaceRequests instanceof SdkAutoConstructList);
    }

    public final List<RebootRequest> rebootWorkspaceRequests() {
        return this.rebootWorkspaceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRebootWorkspaceRequests() ? this.rebootWorkspaceRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootWorkspacesRequest)) {
            return false;
        }
        RebootWorkspacesRequest other = (RebootWorkspacesRequest)((Object)obj);
        return this.hasRebootWorkspaceRequests() == other.hasRebootWorkspaceRequests() && Objects.equals(this.rebootWorkspaceRequests(), other.rebootWorkspaceRequests());
    }

    public final String toString() {
        return ToString.builder((String)"RebootWorkspacesRequest").add("RebootWorkspaceRequests", this.hasRebootWorkspaceRequests() ? this.rebootWorkspaceRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RebootWorkspaceRequests": {
                return Optional.ofNullable(clazz.cast(this.rebootWorkspaceRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<RebootRequest>>> map = new HashMap<String, SdkField<List<RebootRequest>>>();
        map.put("RebootWorkspaceRequests", REBOOT_WORKSPACE_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RebootWorkspacesRequest, T> g) {
        return obj -> g.apply((RebootWorkspacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<RebootRequest> rebootWorkspaceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RebootWorkspacesRequest model) {
            super(model);
            this.rebootWorkspaceRequests(model.rebootWorkspaceRequests);
        }

        public final List<RebootRequest.Builder> getRebootWorkspaceRequests() {
            List<RebootRequest.Builder> result = RebootWorkspaceRequestsCopier.copyToBuilder(this.rebootWorkspaceRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRebootWorkspaceRequests(Collection<RebootRequest.BuilderImpl> rebootWorkspaceRequests) {
            this.rebootWorkspaceRequests = RebootWorkspaceRequestsCopier.copyFromBuilder(rebootWorkspaceRequests);
        }

        @Override
        public final Builder rebootWorkspaceRequests(Collection<RebootRequest> rebootWorkspaceRequests) {
            this.rebootWorkspaceRequests = RebootWorkspaceRequestsCopier.copy(rebootWorkspaceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebootWorkspaceRequests(RebootRequest ... rebootWorkspaceRequests) {
            this.rebootWorkspaceRequests(Arrays.asList(rebootWorkspaceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rebootWorkspaceRequests(Consumer<RebootRequest.Builder> ... rebootWorkspaceRequests) {
            this.rebootWorkspaceRequests(Stream.of(rebootWorkspaceRequests).map(c -> (RebootRequest)((RebootRequest.Builder)RebootRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootWorkspacesRequest build() {
            return new RebootWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RebootWorkspacesRequest> {
        public Builder rebootWorkspaceRequests(Collection<RebootRequest> var1);

        public Builder rebootWorkspaceRequests(RebootRequest ... var1);

        public Builder rebootWorkspaceRequests(Consumer<RebootRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

