/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspaceInstance;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspaceInstancesCopier;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspacesInstancesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkspaceInstancesResponse
extends WorkspacesInstancesResponse
implements ToCopyableBuilder<Builder, ListWorkspaceInstancesResponse> {
    private static final SdkField<List<WorkspaceInstance>> WORKSPACE_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkspaceInstances").getter(ListWorkspaceInstancesResponse.getter(ListWorkspaceInstancesResponse::workspaceInstances)).setter(ListWorkspaceInstancesResponse.setter(Builder::workspaceInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkspaceInstancesResponse.getter(ListWorkspaceInstancesResponse::nextToken)).setter(ListWorkspaceInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkspaceInstancesResponse.memberNameToFieldInitializer();
    private final List<WorkspaceInstance> workspaceInstances;
    private final String nextToken;

    private ListWorkspaceInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.workspaceInstances = builder.workspaceInstances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorkspaceInstances() {
        return this.workspaceInstances != null && !(this.workspaceInstances instanceof SdkAutoConstructList);
    }

    public final List<WorkspaceInstance> workspaceInstances() {
        return this.workspaceInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceInstances() ? this.workspaceInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspaceInstancesResponse)) {
            return false;
        }
        ListWorkspaceInstancesResponse other = (ListWorkspaceInstancesResponse)((Object)obj);
        return this.hasWorkspaceInstances() == other.hasWorkspaceInstances() && Objects.equals(this.workspaceInstances(), other.workspaceInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkspaceInstancesResponse").add("WorkspaceInstances", this.hasWorkspaceInstances() ? this.workspaceInstances() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceInstances": {
                return Optional.ofNullable(clazz.cast(this.workspaceInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkspaceInstances", WORKSPACE_INSTANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspaceInstancesResponse, T> g) {
        return obj -> g.apply((ListWorkspaceInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkspacesInstancesResponse.BuilderImpl
    implements Builder {
        private List<WorkspaceInstance> workspaceInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspaceInstancesResponse model) {
            super(model);
            this.workspaceInstances(model.workspaceInstances);
            this.nextToken(model.nextToken);
        }

        public final List<WorkspaceInstance.Builder> getWorkspaceInstances() {
            List<WorkspaceInstance.Builder> result = WorkspaceInstancesCopier.copyToBuilder(this.workspaceInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaceInstances(Collection<WorkspaceInstance.BuilderImpl> workspaceInstances) {
            this.workspaceInstances = WorkspaceInstancesCopier.copyFromBuilder(workspaceInstances);
        }

        @Override
        public final Builder workspaceInstances(Collection<WorkspaceInstance> workspaceInstances) {
            this.workspaceInstances = WorkspaceInstancesCopier.copy(workspaceInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceInstances(WorkspaceInstance ... workspaceInstances) {
            this.workspaceInstances(Arrays.asList(workspaceInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceInstances(Consumer<WorkspaceInstance.Builder> ... workspaceInstances) {
            this.workspaceInstances(Stream.of(workspaceInstances).map(c -> (WorkspaceInstance)((WorkspaceInstance.Builder)WorkspaceInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkspaceInstancesResponse build() {
            return new ListWorkspaceInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkspacesInstancesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkspaceInstancesResponse> {
        public Builder workspaceInstances(Collection<WorkspaceInstance> var1);

        public Builder workspaceInstances(WorkspaceInstance ... var1);

        public Builder workspaceInstances(Consumer<WorkspaceInstance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

