/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesinstances.model.TenancyEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Placement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Placement> {
    private static final SdkField<String> AFFINITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Affinity").getter(Placement.getter(Placement::affinity)).setter(Placement.setter(Builder::affinity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Affinity").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Placement.getter(Placement::availabilityZone)).setter(Placement.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(Placement.getter(Placement::groupId)).setter(Placement.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(Placement.getter(Placement::groupName)).setter(Placement.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostId").getter(Placement.getter(Placement::hostId)).setter(Placement.setter(Builder::hostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").build()}).build();
    private static final SdkField<String> HOST_RESOURCE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostResourceGroupArn").getter(Placement.getter(Placement::hostResourceGroupArn)).setter(Placement.setter(Builder::hostResourceGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostResourceGroupArn").build()}).build();
    private static final SdkField<Integer> PARTITION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PartitionNumber").getter(Placement.getter(Placement::partitionNumber)).setter(Placement.setter(Builder::partitionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionNumber").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(Placement.getter(Placement::tenancyAsString)).setter(Placement.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFINITY_FIELD, AVAILABILITY_ZONE_FIELD, GROUP_ID_FIELD, GROUP_NAME_FIELD, HOST_ID_FIELD, HOST_RESOURCE_GROUP_ARN_FIELD, PARTITION_NUMBER_FIELD, TENANCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Placement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String affinity;
    private final String availabilityZone;
    private final String groupId;
    private final String groupName;
    private final String hostId;
    private final String hostResourceGroupArn;
    private final Integer partitionNumber;
    private final String tenancy;

    private Placement(BuilderImpl builder) {
        this.affinity = builder.affinity;
        this.availabilityZone = builder.availabilityZone;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.hostId = builder.hostId;
        this.hostResourceGroupArn = builder.hostResourceGroupArn;
        this.partitionNumber = builder.partitionNumber;
        this.tenancy = builder.tenancy;
    }

    public final String affinity() {
        return this.affinity;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String hostId() {
        return this.hostId;
    }

    public final String hostResourceGroupArn() {
        return this.hostResourceGroupArn;
    }

    public final Integer partitionNumber() {
        return this.partitionNumber;
    }

    public final TenancyEnum tenancy() {
        return TenancyEnum.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.affinity());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostResourceGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Placement)) {
            return false;
        }
        Placement other = (Placement)obj;
        return Objects.equals(this.affinity(), other.affinity()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.hostResourceGroupArn(), other.hostResourceGroupArn()) && Objects.equals(this.partitionNumber(), other.partitionNumber()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Placement").add("Affinity", (Object)this.affinity()).add("AvailabilityZone", (Object)this.availabilityZone()).add("GroupId", (Object)this.groupId()).add("GroupName", (Object)this.groupName()).add("HostId", (Object)this.hostId()).add("HostResourceGroupArn", (Object)this.hostResourceGroupArn()).add("PartitionNumber", (Object)this.partitionNumber()).add("Tenancy", (Object)this.tenancyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Affinity": {
                return Optional.ofNullable(clazz.cast(this.affinity()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "HostId": {
                return Optional.ofNullable(clazz.cast(this.hostId()));
            }
            case "HostResourceGroupArn": {
                return Optional.ofNullable(clazz.cast(this.hostResourceGroupArn()));
            }
            case "PartitionNumber": {
                return Optional.ofNullable(clazz.cast(this.partitionNumber()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Affinity", AFFINITY_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("HostId", HOST_ID_FIELD);
        map.put("HostResourceGroupArn", HOST_RESOURCE_GROUP_ARN_FIELD);
        map.put("PartitionNumber", PARTITION_NUMBER_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Placement, T> g) {
        return obj -> g.apply((Placement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String affinity;
        private String availabilityZone;
        private String groupId;
        private String groupName;
        private String hostId;
        private String hostResourceGroupArn;
        private Integer partitionNumber;
        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(Placement model) {
            this.affinity(model.affinity);
            this.availabilityZone(model.availabilityZone);
            this.groupId(model.groupId);
            this.groupName(model.groupName);
            this.hostId(model.hostId);
            this.hostResourceGroupArn(model.hostResourceGroupArn);
            this.partitionNumber(model.partitionNumber);
            this.tenancy(model.tenancy);
        }

        public final String getAffinity() {
            return this.affinity;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getHostId() {
            return this.hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final String getHostResourceGroupArn() {
            return this.hostResourceGroupArn;
        }

        public final void setHostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
        }

        @Override
        public final Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        public final Integer getPartitionNumber() {
            return this.partitionNumber;
        }

        public final void setPartitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
        }

        @Override
        public final Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(TenancyEnum tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public Placement build() {
            return new Placement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Placement> {
        public Builder affinity(String var1);

        public Builder availabilityZone(String var1);

        public Builder groupId(String var1);

        public Builder groupName(String var1);

        public Builder hostId(String var1);

        public Builder hostResourceGroupArn(String var1);

        public Builder partitionNumber(Integer var1);

        public Builder tenancy(String var1);

        public Builder tenancy(TenancyEnum var1);
    }
}

