/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesinstances.model.EC2ManagedInstance;
import software.amazon.awssdk.services.workspacesinstances.model.ProvisionStateEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceInstance> {
    private static final SdkField<String> PROVISION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionState").getter(WorkspaceInstance.getter(WorkspaceInstance::provisionStateAsString)).setter(WorkspaceInstance.setter(Builder::provisionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionState").build()}).build();
    private static final SdkField<String> WORKSPACE_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceInstanceId").getter(WorkspaceInstance.getter(WorkspaceInstance::workspaceInstanceId)).setter(WorkspaceInstance.setter(Builder::workspaceInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceInstanceId").build()}).build();
    private static final SdkField<EC2ManagedInstance> EC2_MANAGED_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EC2ManagedInstance").getter(WorkspaceInstance.getter(WorkspaceInstance::ec2ManagedInstance)).setter(WorkspaceInstance.setter(Builder::ec2ManagedInstance)).constructor(EC2ManagedInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ManagedInstance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISION_STATE_FIELD, WORKSPACE_INSTANCE_ID_FIELD, EC2_MANAGED_INSTANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkspaceInstance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String provisionState;
    private final String workspaceInstanceId;
    private final EC2ManagedInstance ec2ManagedInstance;

    private WorkspaceInstance(BuilderImpl builder) {
        this.provisionState = builder.provisionState;
        this.workspaceInstanceId = builder.workspaceInstanceId;
        this.ec2ManagedInstance = builder.ec2ManagedInstance;
    }

    public final ProvisionStateEnum provisionState() {
        return ProvisionStateEnum.fromValue(this.provisionState);
    }

    public final String provisionStateAsString() {
        return this.provisionState;
    }

    public final String workspaceInstanceId() {
        return this.workspaceInstanceId;
    }

    public final EC2ManagedInstance ec2ManagedInstance() {
        return this.ec2ManagedInstance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2ManagedInstance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceInstance)) {
            return false;
        }
        WorkspaceInstance other = (WorkspaceInstance)obj;
        return Objects.equals(this.provisionStateAsString(), other.provisionStateAsString()) && Objects.equals(this.workspaceInstanceId(), other.workspaceInstanceId()) && Objects.equals(this.ec2ManagedInstance(), other.ec2ManagedInstance());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceInstance").add("ProvisionState", (Object)this.provisionStateAsString()).add("WorkspaceInstanceId", (Object)this.workspaceInstanceId()).add("EC2ManagedInstance", (Object)this.ec2ManagedInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionState": {
                return Optional.ofNullable(clazz.cast(this.provisionStateAsString()));
            }
            case "WorkspaceInstanceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceInstanceId()));
            }
            case "EC2ManagedInstance": {
                return Optional.ofNullable(clazz.cast(this.ec2ManagedInstance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProvisionState", PROVISION_STATE_FIELD);
        map.put("WorkspaceInstanceId", WORKSPACE_INSTANCE_ID_FIELD);
        map.put("EC2ManagedInstance", EC2_MANAGED_INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceInstance, T> g) {
        return obj -> g.apply((WorkspaceInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String provisionState;
        private String workspaceInstanceId;
        private EC2ManagedInstance ec2ManagedInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceInstance model) {
            this.provisionState(model.provisionState);
            this.workspaceInstanceId(model.workspaceInstanceId);
            this.ec2ManagedInstance(model.ec2ManagedInstance);
        }

        public final String getProvisionState() {
            return this.provisionState;
        }

        public final void setProvisionState(String provisionState) {
            this.provisionState = provisionState;
        }

        @Override
        public final Builder provisionState(String provisionState) {
            this.provisionState = provisionState;
            return this;
        }

        @Override
        public final Builder provisionState(ProvisionStateEnum provisionState) {
            this.provisionState(provisionState == null ? null : provisionState.toString());
            return this;
        }

        public final String getWorkspaceInstanceId() {
            return this.workspaceInstanceId;
        }

        public final void setWorkspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
        }

        @Override
        public final Builder workspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
            return this;
        }

        public final EC2ManagedInstance.Builder getEc2ManagedInstance() {
            return this.ec2ManagedInstance != null ? this.ec2ManagedInstance.toBuilder() : null;
        }

        public final void setEc2ManagedInstance(EC2ManagedInstance.BuilderImpl ec2ManagedInstance) {
            this.ec2ManagedInstance = ec2ManagedInstance != null ? ec2ManagedInstance.build() : null;
        }

        @Override
        public final Builder ec2ManagedInstance(EC2ManagedInstance ec2ManagedInstance) {
            this.ec2ManagedInstance = ec2ManagedInstance;
            return this;
        }

        public WorkspaceInstance build() {
            return new WorkspaceInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceInstance> {
        public Builder provisionState(String var1);

        public Builder provisionState(ProvisionStateEnum var1);

        public Builder workspaceInstanceId(String var1);

        public Builder ec2ManagedInstance(EC2ManagedInstance var1);

        default public Builder ec2ManagedInstance(Consumer<EC2ManagedInstance.Builder> ec2ManagedInstance) {
            return this.ec2ManagedInstance((EC2ManagedInstance)((EC2ManagedInstance.Builder)EC2ManagedInstance.builder().applyMutation(ec2ManagedInstance)).build());
        }
    }
}

