/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesinstances.WorkspacesInstancesAsyncClient;
import software.amazon.awssdk.services.workspacesinstances.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesinstances.model.InstanceTypeInfo;
import software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesResponse;

public class ListInstanceTypesPublisher
implements SdkPublisher<ListInstanceTypesResponse> {
    private final WorkspacesInstancesAsyncClient client;
    private final ListInstanceTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceTypesPublisher(WorkspacesInstancesAsyncClient client, ListInstanceTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceTypesPublisher(WorkspacesInstancesAsyncClient client, ListInstanceTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceTypeInfo> instanceTypes() {
        Function<ListInstanceTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceTypes() != null) {
                return response.instanceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInstanceTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInstanceTypesResponseFetcher
    implements AsyncPageFetcher<ListInstanceTypesResponse> {
        private ListInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInstanceTypesResponse> nextPage(ListInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceTypesPublisher.this.client.listInstanceTypes(ListInstanceTypesPublisher.this.firstRequest);
            }
            return ListInstanceTypesPublisher.this.client.listInstanceTypes((ListInstanceTypesRequest)((Object)ListInstanceTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

