/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceTypeEnum {
    INSTANCE("instance"),
    VOLUME("volume"),
    SPOT_INSTANCES_REQUEST("spot-instances-request"),
    NETWORK_INTERFACE("network-interface"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceTypeEnum> VALUE_MAP;
    private final String value;

    private ResourceTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceTypeEnum> knownValues() {
        EnumSet<ResourceTypeEnum> knownValues = EnumSet.allOf(ResourceTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceTypeEnum.class, ResourceTypeEnum::toString);
    }
}

