/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesinstances.model.InstanceInterruptionBehaviorEnum;
import software.amazon.awssdk.services.workspacesinstances.model.SpotInstanceTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotMarketOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotMarketOptions> {
    private static final SdkField<Integer> BLOCK_DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockDurationMinutes").getter(SpotMarketOptions.getter(SpotMarketOptions::blockDurationMinutes)).setter(SpotMarketOptions.setter(Builder::blockDurationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDurationMinutes").build()}).build();
    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceInterruptionBehavior").getter(SpotMarketOptions.getter(SpotMarketOptions::instanceInterruptionBehaviorAsString)).setter(SpotMarketOptions.setter(Builder::instanceInterruptionBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior").build()}).build();
    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxPrice").getter(SpotMarketOptions.getter(SpotMarketOptions::maxPrice)).setter(SpotMarketOptions.setter(Builder::maxPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").build()}).build();
    private static final SdkField<String> SPOT_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotInstanceType").getter(SpotMarketOptions.getter(SpotMarketOptions::spotInstanceTypeAsString)).setter(SpotMarketOptions.setter(Builder::spotInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceType").build()}).build();
    private static final SdkField<Instant> VALID_UNTIL_UTC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidUntilUtc").getter(SpotMarketOptions.getter(SpotMarketOptions::validUntilUtc)).setter(SpotMarketOptions.setter(Builder::validUntilUtc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntilUtc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DURATION_MINUTES_FIELD, INSTANCE_INTERRUPTION_BEHAVIOR_FIELD, MAX_PRICE_FIELD, SPOT_INSTANCE_TYPE_FIELD, VALID_UNTIL_UTC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpotMarketOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer blockDurationMinutes;
    private final String instanceInterruptionBehavior;
    private final String maxPrice;
    private final String spotInstanceType;
    private final Instant validUntilUtc;

    private SpotMarketOptions(BuilderImpl builder) {
        this.blockDurationMinutes = builder.blockDurationMinutes;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.maxPrice = builder.maxPrice;
        this.spotInstanceType = builder.spotInstanceType;
        this.validUntilUtc = builder.validUntilUtc;
    }

    public final Integer blockDurationMinutes() {
        return this.blockDurationMinutes;
    }

    public final InstanceInterruptionBehaviorEnum instanceInterruptionBehavior() {
        return InstanceInterruptionBehaviorEnum.fromValue(this.instanceInterruptionBehavior);
    }

    public final String instanceInterruptionBehaviorAsString() {
        return this.instanceInterruptionBehavior;
    }

    public final String maxPrice() {
        return this.maxPrice;
    }

    public final SpotInstanceTypeEnum spotInstanceType() {
        return SpotInstanceTypeEnum.fromValue(this.spotInstanceType);
    }

    public final String spotInstanceTypeAsString() {
        return this.spotInstanceType;
    }

    public final Instant validUntilUtc() {
        return this.validUntilUtc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInterruptionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntilUtc());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotMarketOptions)) {
            return false;
        }
        SpotMarketOptions other = (SpotMarketOptions)obj;
        return Objects.equals(this.blockDurationMinutes(), other.blockDurationMinutes()) && Objects.equals(this.instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString()) && Objects.equals(this.maxPrice(), other.maxPrice()) && Objects.equals(this.spotInstanceTypeAsString(), other.spotInstanceTypeAsString()) && Objects.equals(this.validUntilUtc(), other.validUntilUtc());
    }

    public final String toString() {
        return ToString.builder((String)"SpotMarketOptions").add("BlockDurationMinutes", (Object)this.blockDurationMinutes()).add("InstanceInterruptionBehavior", (Object)this.instanceInterruptionBehaviorAsString()).add("MaxPrice", (Object)this.maxPrice()).add("SpotInstanceType", (Object)this.spotInstanceTypeAsString()).add("ValidUntilUtc", (Object)this.validUntilUtc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.blockDurationMinutes()));
            }
            case "InstanceInterruptionBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInterruptionBehaviorAsString()));
            }
            case "MaxPrice": {
                return Optional.ofNullable(clazz.cast(this.maxPrice()));
            }
            case "SpotInstanceType": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceTypeAsString()));
            }
            case "ValidUntilUtc": {
                return Optional.ofNullable(clazz.cast(this.validUntilUtc()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BlockDurationMinutes", BLOCK_DURATION_MINUTES_FIELD);
        map.put("InstanceInterruptionBehavior", INSTANCE_INTERRUPTION_BEHAVIOR_FIELD);
        map.put("MaxPrice", MAX_PRICE_FIELD);
        map.put("SpotInstanceType", SPOT_INSTANCE_TYPE_FIELD);
        map.put("ValidUntilUtc", VALID_UNTIL_UTC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpotMarketOptions, T> g) {
        return obj -> g.apply((SpotMarketOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer blockDurationMinutes;
        private String instanceInterruptionBehavior;
        private String maxPrice;
        private String spotInstanceType;
        private Instant validUntilUtc;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotMarketOptions model) {
            this.blockDurationMinutes(model.blockDurationMinutes);
            this.instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            this.maxPrice(model.maxPrice);
            this.spotInstanceType(model.spotInstanceType);
            this.validUntilUtc(model.validUntilUtc);
        }

        public final Integer getBlockDurationMinutes() {
            return this.blockDurationMinutes;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final String getInstanceInterruptionBehavior() {
            return this.instanceInterruptionBehavior;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehaviorEnum instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior == null ? null : instanceInterruptionBehavior.toString());
            return this;
        }

        public final String getMaxPrice() {
            return this.maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final String getSpotInstanceType() {
            return this.spotInstanceType;
        }

        public final void setSpotInstanceType(String spotInstanceType) {
            this.spotInstanceType = spotInstanceType;
        }

        @Override
        public final Builder spotInstanceType(String spotInstanceType) {
            this.spotInstanceType = spotInstanceType;
            return this;
        }

        @Override
        public final Builder spotInstanceType(SpotInstanceTypeEnum spotInstanceType) {
            this.spotInstanceType(spotInstanceType == null ? null : spotInstanceType.toString());
            return this;
        }

        public final Instant getValidUntilUtc() {
            return this.validUntilUtc;
        }

        public final void setValidUntilUtc(Instant validUntilUtc) {
            this.validUntilUtc = validUntilUtc;
        }

        @Override
        public final Builder validUntilUtc(Instant validUntilUtc) {
            this.validUntilUtc = validUntilUtc;
            return this;
        }

        public SpotMarketOptions build() {
            return new SpotMarketOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotMarketOptions> {
        public Builder blockDurationMinutes(Integer var1);

        public Builder instanceInterruptionBehavior(String var1);

        public Builder instanceInterruptionBehavior(InstanceInterruptionBehaviorEnum var1);

        public Builder maxPrice(String var1);

        public Builder spotInstanceType(String var1);

        public Builder spotInstanceType(SpotInstanceTypeEnum var1);

        public Builder validUntilUtc(Instant var1);
    }
}

