/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTimeSeriesServiceStatisticsResponse extends XRayResponse implements
        ToCopyableBuilder<GetTimeSeriesServiceStatisticsResponse.Builder, GetTimeSeriesServiceStatisticsResponse> {
    private static final SdkField<List<TimeSeriesServiceStatistics>> TIME_SERIES_SERVICE_STATISTICS_FIELD = SdkField
            .<List<TimeSeriesServiceStatistics>> builder(MarshallingType.LIST)
            .memberName("TimeSeriesServiceStatistics")
            .getter(getter(GetTimeSeriesServiceStatisticsResponse::timeSeriesServiceStatistics))
            .setter(setter(Builder::timeSeriesServiceStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesServiceStatistics")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeSeriesServiceStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeSeriesServiceStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> CONTAINS_OLD_GROUP_VERSIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ContainsOldGroupVersions")
            .getter(getter(GetTimeSeriesServiceStatisticsResponse::containsOldGroupVersions))
            .setter(setter(Builder::containsOldGroupVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsOldGroupVersions").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetTimeSeriesServiceStatisticsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIME_SERIES_SERVICE_STATISTICS_FIELD, CONTAINS_OLD_GROUP_VERSIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<TimeSeriesServiceStatistics> timeSeriesServiceStatistics;

    private final Boolean containsOldGroupVersions;

    private final String nextToken;

    private GetTimeSeriesServiceStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.timeSeriesServiceStatistics = builder.timeSeriesServiceStatistics;
        this.containsOldGroupVersions = builder.containsOldGroupVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimeSeriesServiceStatistics property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTimeSeriesServiceStatistics() {
        return timeSeriesServiceStatistics != null && !(timeSeriesServiceStatistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The collection of statistics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimeSeriesServiceStatistics} method.
     * </p>
     * 
     * @return The collection of statistics.
     */
    public final List<TimeSeriesServiceStatistics> timeSeriesServiceStatistics() {
        return timeSeriesServiceStatistics;
    }

    /**
     * <p>
     * A flag indicating whether or not a group's filter expression has been consistent, or if a returned aggregation
     * might show statistics from an older version of the group's filter expression.
     * </p>
     * 
     * @return A flag indicating whether or not a group's filter expression has been consistent, or if a returned
     *         aggregation might show statistics from an older version of the group's filter expression.
     */
    public final Boolean containsOldGroupVersions() {
        return containsOldGroupVersions;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTimeSeriesServiceStatistics() ? timeSeriesServiceStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(containsOldGroupVersions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTimeSeriesServiceStatisticsResponse)) {
            return false;
        }
        GetTimeSeriesServiceStatisticsResponse other = (GetTimeSeriesServiceStatisticsResponse) obj;
        return hasTimeSeriesServiceStatistics() == other.hasTimeSeriesServiceStatistics()
                && Objects.equals(timeSeriesServiceStatistics(), other.timeSeriesServiceStatistics())
                && Objects.equals(containsOldGroupVersions(), other.containsOldGroupVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTimeSeriesServiceStatisticsResponse")
                .add("TimeSeriesServiceStatistics", hasTimeSeriesServiceStatistics() ? timeSeriesServiceStatistics() : null)
                .add("ContainsOldGroupVersions", containsOldGroupVersions()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeSeriesServiceStatistics":
            return Optional.ofNullable(clazz.cast(timeSeriesServiceStatistics()));
        case "ContainsOldGroupVersions":
            return Optional.ofNullable(clazz.cast(containsOldGroupVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTimeSeriesServiceStatisticsResponse, T> g) {
        return obj -> g.apply((GetTimeSeriesServiceStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTimeSeriesServiceStatisticsResponse> {
        /**
         * <p>
         * The collection of statistics.
         * </p>
         * 
         * @param timeSeriesServiceStatistics
         *        The collection of statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesServiceStatistics(Collection<TimeSeriesServiceStatistics> timeSeriesServiceStatistics);

        /**
         * <p>
         * The collection of statistics.
         * </p>
         * 
         * @param timeSeriesServiceStatistics
         *        The collection of statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesServiceStatistics(TimeSeriesServiceStatistics... timeSeriesServiceStatistics);

        /**
         * <p>
         * The collection of statistics.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TimeSeriesServiceStatistics>.Builder}
         * avoiding the need to create one manually via {@link List<TimeSeriesServiceStatistics>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TimeSeriesServiceStatistics>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #timeSeriesServiceStatistics(List<TimeSeriesServiceStatistics>)}.
         * 
         * @param timeSeriesServiceStatistics
         *        a consumer that will call methods on {@link List<TimeSeriesServiceStatistics>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesServiceStatistics(List<TimeSeriesServiceStatistics>)
         */
        Builder timeSeriesServiceStatistics(Consumer<TimeSeriesServiceStatistics.Builder>... timeSeriesServiceStatistics);

        /**
         * <p>
         * A flag indicating whether or not a group's filter expression has been consistent, or if a returned
         * aggregation might show statistics from an older version of the group's filter expression.
         * </p>
         * 
         * @param containsOldGroupVersions
         *        A flag indicating whether or not a group's filter expression has been consistent, or if a returned
         *        aggregation might show statistics from an older version of the group's filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsOldGroupVersions(Boolean containsOldGroupVersions);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private List<TimeSeriesServiceStatistics> timeSeriesServiceStatistics = DefaultSdkAutoConstructList.getInstance();

        private Boolean containsOldGroupVersions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTimeSeriesServiceStatisticsResponse model) {
            super(model);
            timeSeriesServiceStatistics(model.timeSeriesServiceStatistics);
            containsOldGroupVersions(model.containsOldGroupVersions);
            nextToken(model.nextToken);
        }

        public final List<TimeSeriesServiceStatistics.Builder> getTimeSeriesServiceStatistics() {
            List<TimeSeriesServiceStatistics.Builder> result = TimeSeriesServiceStatisticsListCopier
                    .copyToBuilder(this.timeSeriesServiceStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesServiceStatistics(
                Collection<TimeSeriesServiceStatistics.BuilderImpl> timeSeriesServiceStatistics) {
            this.timeSeriesServiceStatistics = TimeSeriesServiceStatisticsListCopier.copyFromBuilder(timeSeriesServiceStatistics);
        }

        @Override
        @Transient
        public final Builder timeSeriesServiceStatistics(Collection<TimeSeriesServiceStatistics> timeSeriesServiceStatistics) {
            this.timeSeriesServiceStatistics = TimeSeriesServiceStatisticsListCopier.copy(timeSeriesServiceStatistics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder timeSeriesServiceStatistics(TimeSeriesServiceStatistics... timeSeriesServiceStatistics) {
            timeSeriesServiceStatistics(Arrays.asList(timeSeriesServiceStatistics));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder timeSeriesServiceStatistics(
                Consumer<TimeSeriesServiceStatistics.Builder>... timeSeriesServiceStatistics) {
            timeSeriesServiceStatistics(Stream.of(timeSeriesServiceStatistics)
                    .map(c -> TimeSeriesServiceStatistics.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getContainsOldGroupVersions() {
            return containsOldGroupVersions;
        }

        public final void setContainsOldGroupVersions(Boolean containsOldGroupVersions) {
            this.containsOldGroupVersions = containsOldGroupVersions;
        }

        @Override
        @Transient
        public final Builder containsOldGroupVersions(Boolean containsOldGroupVersions) {
            this.containsOldGroupVersions = containsOldGroupVersions;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTimeSeriesServiceStatisticsResponse build() {
            return new GetTimeSeriesServiceStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
