/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import software.amazon.encryption.s3.S3EncryptionClientException;

public class CryptoFactory {
    public static Cipher createCipher(String algorithm, Provider provider) throws NoSuchPaddingException, NoSuchAlgorithmException {
        if (provider != null) {
            return Cipher.getInstance(algorithm, provider);
        }
        return Cipher.getInstance(algorithm);
    }

    public static KeyGenerator generateKey(String algorithm, Provider provider) {
        KeyGenerator generator;
        try {
            generator = provider == null ? KeyGenerator.getInstance(algorithm) : KeyGenerator.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new S3EncryptionClientException("Unable to generate a(n) " + algorithm + " data key", e);
        }
        return generator;
    }
}

