/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.Provider;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.CipherMode;
import software.amazon.encryption.s3.internal.CipherProvider;
import software.amazon.encryption.s3.materials.CryptographicMaterials;

public final class DecryptionMaterials
implements CryptographicMaterials {
    private final GetObjectRequest _s3Request;
    private final AlgorithmSuite _algorithmSuite;
    private final Map<String, String> _encryptionContext;
    private final byte[] _plaintextDataKey;
    private long _ciphertextLength;
    private Provider _cryptoProvider;
    private String _contentRange;

    private DecryptionMaterials(Builder builder) {
        this._s3Request = builder._s3Request;
        this._algorithmSuite = builder._algorithmSuite;
        this._encryptionContext = builder._encryptionContext;
        this._plaintextDataKey = builder._plaintextDataKey;
        this._ciphertextLength = builder._ciphertextLength;
        this._cryptoProvider = builder._cryptoProvider;
        this._contentRange = builder._contentRange;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetObjectRequest s3Request() {
        return this._s3Request;
    }

    @Override
    public AlgorithmSuite algorithmSuite() {
        return this._algorithmSuite;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="False positive; underlying implementation is immutable")
    public Map<String, String> encryptionContext() {
        return this._encryptionContext;
    }

    public byte[] plaintextDataKey() {
        if (this._plaintextDataKey == null) {
            return null;
        }
        return (byte[])this._plaintextDataKey.clone();
    }

    @Override
    public SecretKey dataKey() {
        return new SecretKeySpec(this._plaintextDataKey, this.algorithmSuite().dataKeyAlgorithm());
    }

    @Override
    public Provider cryptoProvider() {
        return this._cryptoProvider;
    }

    public long ciphertextLength() {
        return this._ciphertextLength;
    }

    @Override
    public CipherMode cipherMode() {
        return CipherMode.DECRYPT;
    }

    @Override
    public Cipher getCipher(byte[] iv) {
        return CipherProvider.createAndInitCipher(this, iv);
    }

    public String getContentRange() {
        return this._contentRange;
    }

    public Builder toBuilder() {
        return new Builder().s3Request(this._s3Request).algorithmSuite(this._algorithmSuite).encryptionContext(this._encryptionContext).plaintextDataKey(this._plaintextDataKey).ciphertextLength(this._ciphertextLength).cryptoProvider(this._cryptoProvider).contentRange(this._contentRange);
    }

    public static class Builder {
        public GetObjectRequest _s3Request = null;
        private Provider _cryptoProvider = null;
        private AlgorithmSuite _algorithmSuite = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF;
        private Map<String, String> _encryptionContext = Collections.emptyMap();
        private byte[] _plaintextDataKey = null;
        private long _ciphertextLength = -1L;
        private String _contentRange = null;

        private Builder() {
        }

        public Builder s3Request(GetObjectRequest s3Request) {
            this._s3Request = s3Request;
            return this;
        }

        public Builder algorithmSuite(AlgorithmSuite algorithmSuite) {
            this._algorithmSuite = algorithmSuite;
            return this;
        }

        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this._encryptionContext = encryptionContext == null ? Collections.emptyMap() : Collections.unmodifiableMap(encryptionContext);
            return this;
        }

        public Builder plaintextDataKey(byte[] plaintextDataKey) {
            this._plaintextDataKey = plaintextDataKey == null ? null : (byte[])plaintextDataKey.clone();
            return this;
        }

        public Builder ciphertextLength(long ciphertextLength) {
            this._ciphertextLength = ciphertextLength;
            return this;
        }

        public Builder cryptoProvider(Provider cryptoProvider) {
            this._cryptoProvider = cryptoProvider;
            return this;
        }

        public Builder contentRange(String contentRange) {
            this._contentRange = contentRange;
            return this;
        }

        public DecryptionMaterials build() {
            return new DecryptionMaterials(this);
        }
    }
}

