/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.encryption.s3.S3EncryptionClientException;

public class InstructionFileConfig {
    private final InstructionFileClientType _clientType;
    private final S3AsyncClient _s3AsyncClient;
    private final S3Client _s3Client;

    private InstructionFileConfig(Builder builder) {
        this._clientType = builder._clientType;
        this._s3Client = builder._s3Client;
        this._s3AsyncClient = builder._s3AsyncClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    ResponseInputStream<GetObjectResponse> getInstructionFile(GetObjectRequest request) {
        switch (this._clientType) {
            case SYNCHRONOUS: {
                return this._s3Client.getObject(request);
            }
            case ASYNC: {
                return (ResponseInputStream)this._s3AsyncClient.getObject(request, AsyncResponseTransformer.toBlockingInputStream()).join();
            }
            case DISABLED: {
                throw new S3EncryptionClientException("Instruction File has been disabled!");
            }
        }
        throw new S3EncryptionClientException("Unknown Instruction File Type");
    }

    public void closeClient() {
        if (this._s3AsyncClient != null) {
            this._s3AsyncClient.close();
        }
        if (this._s3Client != null) {
            this._s3Client.close();
        }
    }

    public static class Builder {
        private InstructionFileClientType _clientType;
        private boolean _disableInstructionFile;
        private S3AsyncClient _s3AsyncClient;
        private S3Client _s3Client;

        public Builder disableInstructionFile(boolean disableInstructionFile) {
            this._disableInstructionFile = disableInstructionFile;
            return this;
        }

        public Builder instructionFileClient(S3Client instructionFileClient) {
            this._s3Client = instructionFileClient;
            return this;
        }

        public Builder instructionFileAsyncClient(S3AsyncClient instructionFileAsyncClient) {
            this._s3AsyncClient = instructionFileAsyncClient;
            return this;
        }

        public InstructionFileConfig build() {
            if ((this._s3AsyncClient != null || this._s3Client != null) && this._disableInstructionFile) {
                throw new S3EncryptionClientException("Instruction Files have been disabled but a client has been passed!");
            }
            if (this._disableInstructionFile) {
                this._clientType = InstructionFileClientType.DISABLED;
                return new InstructionFileConfig(this);
            }
            if (this._s3Client != null && this._s3AsyncClient != null) {
                throw new S3EncryptionClientException("Only one instruction file client may be set.");
            }
            if (this._s3Client != null) {
                this._clientType = InstructionFileClientType.SYNCHRONOUS;
            } else if (this._s3AsyncClient != null) {
                this._clientType = InstructionFileClientType.ASYNC;
            } else {
                throw new S3EncryptionClientException("At least one instruction file client must be set or Instruction Files MUST be disabled.");
            }
            return new InstructionFileConfig(this);
        }
    }

    public static enum InstructionFileClientType {
        DISABLED,
        SYNCHRONOUS,
        ASYNC;

    }
}

