/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.encryption.s3.S3EncryptionClientException;

public class NoRetriesAsyncRequestBody
implements AsyncRequestBody {
    private final AsyncRequestBody wrappedAsyncRequestBody;
    private final AtomicBoolean subscribeCalled = new AtomicBoolean(false);

    public NoRetriesAsyncRequestBody(AsyncRequestBody wrappedAsyncRequestBody) {
        this.wrappedAsyncRequestBody = wrappedAsyncRequestBody;
    }

    public Optional<Long> contentLength() {
        return this.wrappedAsyncRequestBody.contentLength();
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        if (!this.subscribeCalled.compareAndSet(false, true)) {
            throw new S3EncryptionClientException("Re-subscription is not supported! Retry the entire operation.");
        }
        this.wrappedAsyncRequestBody.subscribe(subscriber);
    }
}

