/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

public class EncryptedDataKey {
    private final String _keyProviderId;
    private final String _keyProviderInfo;
    private final byte[] _encryptedDataKey;

    private EncryptedDataKey(Builder builder) {
        this._keyProviderId = builder._keyProviderId;
        this._keyProviderInfo = builder._keyProviderInfo;
        this._encryptedDataKey = builder._encryptedDataKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String keyProviderId() {
        return this._keyProviderId;
    }

    public String keyProviderInfo() {
        return this._keyProviderInfo;
    }

    public byte[] encryptedDatakey() {
        if (this._encryptedDataKey == null) {
            return null;
        }
        return (byte[])this._encryptedDataKey.clone();
    }

    public static class Builder {
        private String _keyProviderId = null;
        private String _keyProviderInfo = null;
        private byte[] _encryptedDataKey = null;

        private Builder() {
        }

        public Builder keyProviderId(String keyProviderId) {
            this._keyProviderId = keyProviderId;
            return this;
        }

        public Builder keyProviderInfo(String keyProviderInfo) {
            this._keyProviderInfo = keyProviderInfo;
            return this;
        }

        public Builder encryptedDataKey(byte[] encryptedDataKey) {
            this._encryptedDataKey = encryptedDataKey == null ? null : (byte[])encryptedDataKey.clone();
            return this;
        }

        public EncryptedDataKey build() {
            return new EncryptedDataKey(this);
        }
    }
}

