/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.util.HashMap;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.encryption.s3.S3EncryptionClientException;

public class InstructionFileConfig {
    private final InstructionFileClientType _clientType;
    private final S3AsyncClient _s3AsyncClient;
    private final S3Client _s3Client;
    private final boolean _enableInstructionFilePut;

    private InstructionFileConfig(Builder builder) {
        this._clientType = builder._clientType;
        this._s3Client = builder._s3Client;
        this._s3AsyncClient = builder._s3AsyncClient;
        this._enableInstructionFilePut = builder._enableInstructionFilePut;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isInstructionFilePutEnabled() {
        return this._enableInstructionFilePut;
    }

    PutObjectResponse putInstructionFile(PutObjectRequest request, String instructionFileContent) {
        return this.putInstructionFile(request, instructionFileContent, ".instruction");
    }

    PutObjectResponse putInstructionFile(PutObjectRequest request, String instructionFileContent, String instructionFileSuffix) {
        if (!this._enableInstructionFilePut) {
            throw new S3EncryptionClientException("Enable Instruction File Put must be set to true in order to call PutObject with an instruction file!");
        }
        HashMap<String, String> instFileMetadata = new HashMap<String, String>(1);
        instFileMetadata.put("x-amz-crypto-instr-file", "");
        PutObjectRequest instPutRequest = (PutObjectRequest)request.toBuilder().key(request.key() + instructionFileSuffix).contentLength(Long.valueOf(instructionFileContent.getBytes().length)).metadata(instFileMetadata).build();
        switch (this._clientType) {
            case SYNCHRONOUS: {
                return this._s3Client.putObject(instPutRequest, RequestBody.fromString((String)instructionFileContent));
            }
            case ASYNC: {
                return (PutObjectResponse)this._s3AsyncClient.putObject(instPutRequest, AsyncRequestBody.fromString((String)instructionFileContent)).join();
            }
            case DISABLED: {
                throw new S3EncryptionClientException("Instruction File has been disabled!");
            }
        }
        throw new S3EncryptionClientException("Unknown Instruction File Type");
    }

    ResponseInputStream<GetObjectResponse> getInstructionFile(GetObjectRequest request) {
        switch (this._clientType) {
            case SYNCHRONOUS: {
                return this._s3Client.getObject(request);
            }
            case ASYNC: {
                return (ResponseInputStream)this._s3AsyncClient.getObject(request, AsyncResponseTransformer.toBlockingInputStream()).join();
            }
            case DISABLED: {
                throw new S3EncryptionClientException("Instruction File has been disabled!");
            }
        }
        throw new S3EncryptionClientException("Unknown Instruction File Type");
    }

    public void closeClient() {
        if (this._s3AsyncClient != null) {
            this._s3AsyncClient.close();
        }
        if (this._s3Client != null) {
            this._s3Client.close();
        }
    }

    public static class Builder {
        private InstructionFileClientType _clientType;
        private boolean _disableInstructionFile;
        private S3AsyncClient _s3AsyncClient;
        private S3Client _s3Client;
        private boolean _enableInstructionFilePut = false;

        public Builder disableInstructionFile(boolean disableInstructionFile) {
            this._disableInstructionFile = disableInstructionFile;
            return this;
        }

        public Builder enableInstructionFilePutObject(boolean enableInstructionFilePutObject) {
            this._enableInstructionFilePut = enableInstructionFilePutObject;
            return this;
        }

        public Builder instructionFileClient(S3Client instructionFileClient) {
            this._s3Client = instructionFileClient;
            return this;
        }

        public Builder instructionFileAsyncClient(S3AsyncClient instructionFileAsyncClient) {
            this._s3AsyncClient = instructionFileAsyncClient;
            return this;
        }

        public InstructionFileConfig build() {
            if ((this._s3AsyncClient != null || this._s3Client != null) && this._disableInstructionFile) {
                throw new S3EncryptionClientException("Instruction Files have been disabled but a client has been passed!");
            }
            if (this._disableInstructionFile) {
                this._clientType = InstructionFileClientType.DISABLED;
                if (this._enableInstructionFilePut) {
                    throw new S3EncryptionClientException("Instruction Files must be enabled to enable Instruction Files for PutObject.");
                }
                return new InstructionFileConfig(this);
            }
            if (this._s3Client != null && this._s3AsyncClient != null) {
                throw new S3EncryptionClientException("Only one instruction file client may be set.");
            }
            if (this._s3Client != null) {
                this._clientType = InstructionFileClientType.SYNCHRONOUS;
            } else if (this._s3AsyncClient != null) {
                this._clientType = InstructionFileClientType.ASYNC;
            } else {
                throw new S3EncryptionClientException("At least one instruction file client must be set or Instruction Files MUST be disabled.");
            }
            return new InstructionFileConfig(this);
        }
    }

    public static enum InstructionFileClientType {
        DISABLED,
        SYNCHRONOUS,
        ASYNC;

    }
}

