/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.MessageDigest;
import java.security.Provider;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.CipherMode;
import software.amazon.encryption.s3.materials.CryptographicMaterials;
import software.amazon.encryption.s3.materials.EncryptionMaterials;

public class MultipartUploadMaterials
implements CryptographicMaterials {
    private final S3Request _s3Request;
    private final AlgorithmSuite _algorithmSuite;
    private final Map<String, String> _encryptionContext;
    private final byte[] _plaintextDataKey;
    private final Provider _cryptoProvider;
    private long _plaintextLength;
    private boolean hasFinalPartBeenSeen;
    private final Cipher _cipher;
    private int partNumber;
    private volatile boolean partUploadInProgress;

    private MultipartUploadMaterials(Builder builder) {
        this._s3Request = builder._s3Request;
        this._algorithmSuite = builder._algorithmSuite;
        this._encryptionContext = builder._encryptionContext;
        this._plaintextDataKey = builder._plaintextDataKey;
        this._cryptoProvider = builder._cryptoProvider;
        this._plaintextLength = builder._plaintextLength;
        this._cipher = builder._cipher;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final boolean hasFinalPartBeenSeen() {
        return this.hasFinalPartBeenSeen;
    }

    public final void setHasFinalPartBeenSeen(boolean hasFinalPartBeenSeen) {
        this.hasFinalPartBeenSeen = hasFinalPartBeenSeen;
    }

    @Override
    public Cipher getCipher(byte[] iv) {
        if (!MessageDigest.isEqual(iv, this._cipher.getIV())) {
            throw new S3EncryptionClientException("IVs in MultipartUploadMaterials do not match!");
        }
        return this._cipher;
    }

    public byte[] getIv() {
        return this._cipher.getIV();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginPartUpload(int nextPartNumber, long partContentLength) {
        if (nextPartNumber < 1) {
            throw new IllegalArgumentException("part number must be at least 1");
        }
        if (this.partUploadInProgress) {
            throw new S3EncryptionClientException("Parts are required to be uploaded in series");
        }
        MultipartUploadMaterials multipartUploadMaterials = this;
        synchronized (multipartUploadMaterials) {
            if (nextPartNumber - this.partNumber > 1) {
                throw new S3EncryptionClientException("Parts are required to be uploaded in series (partNumber=" + this.partNumber + ", nextPartNumber=" + nextPartNumber + ")");
            }
            this.partNumber = nextPartNumber;
            this.partUploadInProgress = true;
            this.incrementPlaintextSize(partContentLength);
        }
    }

    private synchronized long incrementPlaintextSize(long lengthOfPartToAdd) {
        if (this._plaintextLength + lengthOfPartToAdd > AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherMaxContentLengthBytes()) {
            throw new S3EncryptionClientException("The contentLength of the object you are attempting to encrypt exceedsthe maximum length allowed for GCM encryption.");
        }
        this._plaintextLength += lengthOfPartToAdd;
        return this._plaintextLength;
    }

    protected void endPartUpload() {
        this.partUploadInProgress = false;
    }

    @Override
    public AlgorithmSuite algorithmSuite() {
        return this._algorithmSuite;
    }

    @Override
    public S3Request s3Request() {
        return this._s3Request;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="False positive; underlying implementation is immutable")
    public Map<String, String> encryptionContext() {
        return this._encryptionContext;
    }

    @Override
    public SecretKey dataKey() {
        return new SecretKeySpec(this._plaintextDataKey, this.algorithmSuite().dataKeyAlgorithm());
    }

    @Override
    public Provider cryptoProvider() {
        return this._cryptoProvider;
    }

    @Override
    public CipherMode cipherMode() {
        return CipherMode.MULTIPART_ENCRYPT;
    }

    public static class Builder {
        private S3Request _s3Request = null;
        private AlgorithmSuite _algorithmSuite = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF;
        private Map<String, String> _encryptionContext = Collections.emptyMap();
        private byte[] _plaintextDataKey = null;
        private long _plaintextLength = 0L;
        private Provider _cryptoProvider = null;
        private Cipher _cipher = null;

        private Builder() {
        }

        public Builder cipher(Cipher cipher) {
            this._cipher = cipher;
            return this;
        }

        public Builder fromEncryptionMaterials(EncryptionMaterials materials) {
            this._s3Request = materials.s3Request();
            this._algorithmSuite = materials.algorithmSuite();
            this._encryptionContext = materials.encryptionContext();
            this._plaintextDataKey = materials.plaintextDataKey();
            this._cryptoProvider = materials.cryptoProvider();
            return this;
        }

        public MultipartUploadMaterials build() {
            return new MultipartUploadMaterials(this);
        }
    }
}

