/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.CipherMode;
import software.amazon.encryption.s3.internal.CipherProvider;
import software.amazon.encryption.s3.materials.CryptographicMaterials;
import software.amazon.encryption.s3.materials.EncryptedDataKey;
import software.amazon.encryption.s3.materials.MaterialsDescription;

public final class EncryptionMaterials
implements CryptographicMaterials {
    private final S3Request _s3Request;
    private final AlgorithmSuite _algorithmSuite;
    private final Map<String, String> _encryptionContext;
    private final MaterialsDescription _materialsDescription;
    private final List<EncryptedDataKey> _encryptedDataKeys;
    private final byte[] _plaintextDataKey;
    private final Provider _cryptoProvider;
    private final long _plaintextLength;
    private final long _ciphertextLength;

    private EncryptionMaterials(Builder builder) {
        this._s3Request = builder._s3Request;
        this._algorithmSuite = builder._algorithmSuite;
        this._encryptionContext = builder._encryptionContext;
        this._encryptedDataKeys = builder._encryptedDataKeys;
        this._plaintextDataKey = builder._plaintextDataKey;
        this._cryptoProvider = builder._cryptoProvider;
        this._plaintextLength = builder._plaintextLength;
        this._ciphertextLength = this._plaintextLength + (long)this._algorithmSuite.cipherTagLengthBytes();
        this._materialsDescription = builder._materialsDescription;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public S3Request s3Request() {
        return this._s3Request;
    }

    @Override
    public AlgorithmSuite algorithmSuite() {
        return this._algorithmSuite;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="False positive; underlying implementation is immutable")
    public Map<String, String> encryptionContext() {
        return this._encryptionContext;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="False positive; underlying implementation is immutable")
    public List<EncryptedDataKey> encryptedDataKeys() {
        return this._encryptedDataKeys;
    }

    public byte[] plaintextDataKey() {
        if (this._plaintextDataKey == null) {
            return null;
        }
        return (byte[])this._plaintextDataKey.clone();
    }

    public long getPlaintextLength() {
        return this._plaintextLength;
    }

    public long getCiphertextLength() {
        return this._ciphertextLength;
    }

    @Override
    public SecretKey dataKey() {
        return new SecretKeySpec(this._plaintextDataKey, this.algorithmSuite().dataKeyAlgorithm());
    }

    @Override
    public Provider cryptoProvider() {
        return this._cryptoProvider;
    }

    public MaterialsDescription materialsDescription() {
        return this._materialsDescription;
    }

    @Override
    public CipherMode cipherMode() {
        return CipherMode.ENCRYPT;
    }

    @Override
    public Cipher getCipher(byte[] iv) {
        return CipherProvider.createAndInitCipher(this, iv, null);
    }

    public Builder toBuilder() {
        return new Builder().s3Request(this._s3Request).algorithmSuite(this._algorithmSuite).encryptionContext(this._encryptionContext).encryptedDataKeys(this._encryptedDataKeys).plaintextDataKey(this._plaintextDataKey).cryptoProvider(this._cryptoProvider).materialsDescription(this._materialsDescription).plaintextLength(this._plaintextLength);
    }

    public static class Builder {
        private S3Request _s3Request = null;
        private AlgorithmSuite _algorithmSuite = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF;
        private Map<String, String> _encryptionContext = Collections.emptyMap();
        private List<EncryptedDataKey> _encryptedDataKeys = Collections.emptyList();
        private byte[] _plaintextDataKey = null;
        private long _plaintextLength = -1L;
        private Provider _cryptoProvider = null;
        private MaterialsDescription _materialsDescription = MaterialsDescription.builder().build();

        private Builder() {
        }

        public Builder s3Request(S3Request s3Request) {
            this._s3Request = s3Request;
            return this;
        }

        public Builder algorithmSuite(AlgorithmSuite algorithmSuite) {
            this._algorithmSuite = algorithmSuite;
            return this;
        }

        public Builder materialsDescription(MaterialsDescription materialsDescription) {
            this._materialsDescription = materialsDescription == null ? MaterialsDescription.builder().build() : materialsDescription;
            return this;
        }

        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this._encryptionContext = encryptionContext == null ? Collections.emptyMap() : Collections.unmodifiableMap(encryptionContext);
            return this;
        }

        public Builder encryptedDataKeys(List<EncryptedDataKey> encryptedDataKeys) {
            this._encryptedDataKeys = encryptedDataKeys == null ? Collections.emptyList() : Collections.unmodifiableList(encryptedDataKeys);
            return this;
        }

        public Builder plaintextDataKey(byte[] plaintextDataKey) {
            this._plaintextDataKey = plaintextDataKey == null ? null : (byte[])plaintextDataKey.clone();
            return this;
        }

        public Builder cryptoProvider(Provider cryptoProvider) {
            this._cryptoProvider = cryptoProvider;
            return this;
        }

        public Builder plaintextLength(long plaintextLength) {
            this._plaintextLength = plaintextLength;
            return this;
        }

        public EncryptionMaterials build() {
            if (!this._materialsDescription.isEmpty() && !this._encryptionContext.isEmpty()) {
                throw new S3EncryptionClientException("MaterialsDescription and EncryptionContext cannot both be set!");
            }
            return new EncryptionMaterials(this);
        }
    }
}

