/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.algorithms;

public enum AlgorithmSuite {
    ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY(115, false, "AES", 256, "AES/GCM/NoPadding", 128, 96, 128, 0x7FFFFFFF00L, true, 224, 224, "HmacSHA512"),
    ALG_AES_256_CTR_HKDF_SHA512_COMMIT_KEY(116, true, "AES", 256, "AES/CTR/NoPadding", 128, 128, 128, -1L, true, 224, 224, "HmacSHA512"),
    ALG_AES_256_GCM_IV12_TAG16_NO_KDF(114, false, "AES", 256, "AES/GCM/NoPadding", 128, 96, 128, 0x7FFFFFFF00L, false, 0, 0, ""),
    ALG_AES_256_CTR_IV16_TAG16_NO_KDF(113, true, "AES", 256, "AES/CTR/NoPadding", 128, 128, 128, -1L, false, 0, 0, ""),
    ALG_AES_256_CBC_IV16_NO_KDF(112, true, "AES", 256, "AES/CBC/PKCS5Padding", 128, 128, 0, 0x80000000000000L, false, 0, 0, "");

    private final int _id;
    private final boolean _isLegacy;
    private final String _dataKeyAlgorithm;
    private final int _dataKeyLengthBits;
    private final String _cipherName;
    private final int _cipherBlockSizeBits;
    private final int _cipherIvLengthBits;
    private final int _cipherTagLengthBits;
    private final long _cipherMaxContentLengthBits;
    private final boolean _isCommitting;
    private final int _commitmentLengthBits;
    private final int _commitmentNonceLengthBits;
    private final String _kdfHashAlgorithm;

    private AlgorithmSuite(int id, boolean isLegacy, String dataKeyAlgorithm, int dataKeyLengthBits, String cipherName, int cipherBlockSizeBits, int cipherIvLengthBits, int cipherTagLengthBits, long cipherMaxContentLengthBits, boolean isCommitting, int commitmentLength, int commitmentNonceLengthBits, String kdfHashAlgorithm) {
        this._id = id;
        this._isLegacy = isLegacy;
        this._dataKeyAlgorithm = dataKeyAlgorithm;
        this._dataKeyLengthBits = dataKeyLengthBits;
        this._cipherName = cipherName;
        this._cipherBlockSizeBits = cipherBlockSizeBits;
        this._cipherIvLengthBits = cipherIvLengthBits;
        this._cipherTagLengthBits = cipherTagLengthBits;
        this._cipherMaxContentLengthBits = cipherMaxContentLengthBits;
        this._isCommitting = isCommitting;
        this._commitmentLengthBits = commitmentLength;
        this._commitmentNonceLengthBits = commitmentNonceLengthBits;
        this._kdfHashAlgorithm = kdfHashAlgorithm;
    }

    public int id() {
        return this._id;
    }

    public String idAsString() {
        return String.valueOf(this._id);
    }

    public byte[] idAsBytes() {
        return new byte[]{(byte)(this._id >> 8), (byte)this._id};
    }

    public boolean isLegacy() {
        return this._isLegacy;
    }

    public String dataKeyAlgorithm() {
        return this._dataKeyAlgorithm;
    }

    public int dataKeyLengthBits() {
        return this._dataKeyLengthBits;
    }

    public int dataKeyLengthBytes() {
        return this._dataKeyLengthBits / 8;
    }

    public String cipherName() {
        return this._cipherName;
    }

    public int cipherTagLengthBits() {
        return this._cipherTagLengthBits;
    }

    public int cipherTagLengthBytes() {
        return this._cipherTagLengthBits / 8;
    }

    public int iVLengthBytes() {
        return this._cipherIvLengthBits / 8;
    }

    public int cipherBlockSizeBytes() {
        return this._cipherBlockSizeBits / 8;
    }

    public long cipherMaxContentLengthBits() {
        return this._cipherMaxContentLengthBits;
    }

    public long cipherMaxContentLengthBytes() {
        return this._cipherMaxContentLengthBits / 8L;
    }

    public boolean isCommitting() {
        return this._isCommitting;
    }

    public int commitmentLengthBits() {
        return this._commitmentLengthBits;
    }

    public int commitmentLengthBytes() {
        return this._commitmentLengthBits / 8;
    }

    public String kdfHashAlgorithm() {
        return this._kdfHashAlgorithm;
    }

    public int commitmentNonceLengthBits() {
        return this._commitmentNonceLengthBits;
    }

    public int commitmentNonceLengthBytes() {
        return this._commitmentNonceLengthBits / 8;
    }
}

