/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import java.security.Provider;
import software.amazon.encryption.s3.materials.CryptographicMaterialsManager;
import software.amazon.encryption.s3.materials.DecryptMaterialsRequest;
import software.amazon.encryption.s3.materials.DecryptionMaterials;
import software.amazon.encryption.s3.materials.EncryptionMaterials;
import software.amazon.encryption.s3.materials.EncryptionMaterialsRequest;
import software.amazon.encryption.s3.materials.Keyring;

public class DefaultCryptoMaterialsManager
implements CryptographicMaterialsManager {
    private final Keyring _keyring;
    private final Provider _cryptoProvider;

    private DefaultCryptoMaterialsManager(Builder builder) {
        this._keyring = builder._keyring;
        this._cryptoProvider = builder._cryptoProvider;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials(EncryptionMaterialsRequest request) {
        EncryptionMaterials materials = EncryptionMaterials.builder().s3Request(request.s3Request()).algorithmSuite(request.encryptionAlgorithm()).encryptionContext(request.encryptionContext()).cryptoProvider(this._cryptoProvider).plaintextLength(request.plaintextLength()).build();
        return this._keyring.onEncrypt(materials);
    }

    @Override
    public DecryptionMaterials decryptMaterials(DecryptMaterialsRequest request) {
        DecryptionMaterials materials = DecryptionMaterials.builder().s3Request(request.s3Request()).algorithmSuite(request.algorithmSuite()).encryptionContext(request.encryptionContext()).materialsDescription(request.materialsDescription()).ciphertextLength(request.ciphertextLength()).cryptoProvider(this._cryptoProvider).contentRange(request.contentRange()).keyCommitment(request.keyCommitment()).build();
        return this._keyring.onDecrypt(materials, request.encryptedDataKeys());
    }

    public static class Builder {
        private Keyring _keyring;
        private Provider _cryptoProvider;

        private Builder() {
        }

        public Builder keyring(Keyring keyring) {
            this._keyring = keyring;
            return this;
        }

        public Builder cryptoProvider(Provider cryptoProvider) {
            this._cryptoProvider = cryptoProvider;
            return this;
        }

        public DefaultCryptoMaterialsManager build() {
            return new DefaultCryptoMaterialsManager(this);
        }
    }
}

