/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import software.amazon.encryption.s3.materials.MaterialsDescription;
import software.amazon.encryption.s3.materials.PartialRsaKeyPair;
import software.amazon.encryption.s3.materials.RawKeyMaterial;

public class RsaKeyMaterial
extends RawKeyMaterial<PartialRsaKeyPair> {
    public RsaKeyMaterial(MaterialsDescription materialsDescription, PartialRsaKeyPair keyMaterial) {
        super(materialsDescription, keyMaterial);
    }

    public static Builder rsaBuilder() {
        return new Builder();
    }

    public static class Builder {
        private MaterialsDescription _materialsDescription;
        private PartialRsaKeyPair _keyMaterial;

        public Builder materialsDescription(MaterialsDescription materialsDescription) {
            this._materialsDescription = materialsDescription;
            return this;
        }

        public Builder keyMaterial(PartialRsaKeyPair keyMaterial) {
            this._keyMaterial = keyMaterial;
            return this;
        }

        public RsaKeyMaterial build() {
            return new RsaKeyMaterial(this._materialsDescription, this._keyMaterial);
        }
    }
}

