/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.materials.DataKeyGenerator;
import software.amazon.encryption.s3.materials.DecryptDataKeyStrategy;
import software.amazon.encryption.s3.materials.DecryptionMaterials;
import software.amazon.encryption.s3.materials.DefaultDataKeyGenerator;
import software.amazon.encryption.s3.materials.EncryptDataKeyStrategy;
import software.amazon.encryption.s3.materials.EncryptedDataKey;
import software.amazon.encryption.s3.materials.EncryptionMaterials;
import software.amazon.encryption.s3.materials.GenerateDataKeyStrategy;
import software.amazon.encryption.s3.materials.Keyring;

public abstract class S3Keyring
implements Keyring {
    public static final String KEY_PROVIDER_ID = "S3Keyring";
    protected final DataKeyGenerator _dataKeyGenerator;
    private final boolean _enableLegacyWrappingAlgorithms;
    private final SecureRandom _secureRandom;

    protected S3Keyring(Builder<?, ?> builder) {
        this._enableLegacyWrappingAlgorithms = ((Builder)builder)._enableLegacyWrappingAlgorithms;
        this._secureRandom = ((Builder)builder)._secureRandom;
        this._dataKeyGenerator = ((Builder)builder)._dataKeyGenerator;
    }

    public boolean areLegacyWrappingAlgorithmsEnabled() {
        return this._enableLegacyWrappingAlgorithms;
    }

    public EncryptionMaterials defaultGenerateDataKey(EncryptionMaterials materials) {
        SecretKey dataKey = this._dataKeyGenerator.generateDataKey(materials.algorithmSuite(), materials.cryptoProvider());
        return materials.toBuilder().plaintextDataKey(dataKey.getEncoded()).build();
    }

    @Override
    public EncryptionMaterials onEncrypt(EncryptionMaterials materials) {
        EncryptDataKeyStrategy encryptStrategy = this.encryptDataKeyStrategy();
        materials = encryptStrategy.modifyMaterials(materials);
        if (materials.plaintextDataKey() == null) {
            materials = this.generateDataKeyStrategy().generateDataKey(materials);
        }
        if (!materials.encryptedDataKeys().isEmpty()) {
            return materials;
        }
        try {
            byte[] encryptedDataKeyCiphertext = encryptStrategy.encryptDataKey(this._secureRandom, materials);
            EncryptedDataKey encryptedDataKey = EncryptedDataKey.builder().keyProviderId(KEY_PROVIDER_ID).keyProviderInfo(encryptStrategy.keyProviderInfo()).encryptedDataKey(encryptedDataKeyCiphertext).build();
            ArrayList<EncryptedDataKey> encryptedDataKeys = new ArrayList<EncryptedDataKey>(materials.encryptedDataKeys());
            encryptedDataKeys.add(encryptedDataKey);
            return materials.toBuilder().encryptedDataKeys(encryptedDataKeys).build();
        }
        catch (Exception e) {
            throw new S3EncryptionClientException("Unable to " + encryptStrategy.keyProviderInfo() + " wrap", e);
        }
    }

    protected abstract GenerateDataKeyStrategy generateDataKeyStrategy();

    protected abstract EncryptDataKeyStrategy encryptDataKeyStrategy();

    @Override
    public DecryptionMaterials onDecrypt(DecryptionMaterials materials, List<EncryptedDataKey> encryptedDataKeys) {
        if (materials.plaintextDataKey() != null) {
            throw new S3EncryptionClientException("Decryption materials already contains a plaintext data key.");
        }
        if (encryptedDataKeys.size() != 1) {
            throw new S3EncryptionClientException("Only one encrypted data key is supported, found: " + encryptedDataKeys.size());
        }
        EncryptedDataKey encryptedDataKey = encryptedDataKeys.get(0);
        String keyProviderId = encryptedDataKey.keyProviderId();
        if (!KEY_PROVIDER_ID.equals(keyProviderId)) {
            throw new S3EncryptionClientException("Unknown key provider: " + keyProviderId);
        }
        String keyProviderInfo = encryptedDataKey.keyProviderInfo();
        DecryptDataKeyStrategy decryptStrategy = this.decryptDataKeyStrategies().get(keyProviderInfo);
        if (decryptStrategy == null) {
            throw new S3EncryptionClientException("The keyring does not support the object's key wrapping algorithm: " + keyProviderInfo);
        }
        if (decryptStrategy.isLegacy() && !this._enableLegacyWrappingAlgorithms) {
            throw new S3EncryptionClientException("Enable legacy wrapping algorithms to use legacy key wrapping algorithm: " + keyProviderInfo);
        }
        try {
            byte[] plaintext = decryptStrategy.decryptDataKey(materials, encryptedDataKey.encryptedDatakey());
            return materials.toBuilder().plaintextDataKey(plaintext).build();
        }
        catch (GeneralSecurityException e) {
            throw new S3EncryptionClientException("Unable to " + keyProviderInfo + " unwrap", e);
        }
    }

    protected abstract Map<String, DecryptDataKeyStrategy> decryptDataKeyStrategies();

    public static abstract class Builder<KeyringT extends S3Keyring, BuilderT extends Builder<KeyringT, BuilderT>> {
        private boolean _enableLegacyWrappingAlgorithms = false;
        private SecureRandom _secureRandom = new SecureRandom();
        private DataKeyGenerator _dataKeyGenerator = new DefaultDataKeyGenerator();

        protected Builder() {
        }

        protected abstract BuilderT builder();

        public BuilderT enableLegacyWrappingAlgorithms(boolean shouldEnableLegacyWrappingAlgorithms) {
            this._enableLegacyWrappingAlgorithms = shouldEnableLegacyWrappingAlgorithms;
            return this.builder();
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public BuilderT secureRandom(SecureRandom secureRandom) {
            if (secureRandom == null) {
                throw new S3EncryptionClientException("SecureRandom provided to S3Keyring cannot be null");
            }
            this._secureRandom = secureRandom;
            return this.builder();
        }

        public BuilderT dataKeyGenerator(DataKeyGenerator dataKeyGenerator) {
            if (dataKeyGenerator == null) {
                throw new S3EncryptionClientException("DataKeyGenerator cannot be null!");
            }
            this._dataKeyGenerator = dataKeyGenerator;
            return this.builder();
        }

        public abstract KeyringT build();
    }
}

