/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.SimpleGraphBuilder;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;

public class AudioCodecPipe {
    static final int STAGES = 5;
    Codec[] codecs = null;
    Buffer[] buffers = null;
    Format[] formats = new Format[5];
    AudioFormat finalFormat = null;
    AudioFormat inputFormat = null;
    Buffer inputBuffer = null;

    public AudioCodecPipe() {
    }

    public AudioCodecPipe(AudioFormat input, AudioFormat[] desired, int bufsize) throws UnsupportedFormatException {
        Vector<Codec> codecList = new Vector<Codec>(1);
        Format af = input;
        int stages = 0;
        AudioFormat linearFormat = new AudioFormat("LINEAR");
        AudioFormat ulawFormat = new AudioFormat("ULAW", 8000.0, 8, 1);
        Format[] in = new AudioFormat[1];
        Format[] out = new AudioFormat[1];
        this.finalFormat = input;
        this.inputFormat = input;
        while (stages < 4) {
            Codec codec;
            if (this.match((AudioFormat)af, desired, (AudioFormat[])in, (AudioFormat[])out)) break;
            if (af.matches(ulawFormat)) {
                codec = SimpleGraphBuilder.findCodec(af, linearFormat, in, out);
                if (codec != null) {
                    codecList.addElement(codec);
                    af = out[0];
                    this.formats[stages] = af;
                    ++stages;
                    continue;
                }
                throw new UnsupportedFormatException(af);
            }
            if (af.matches(linearFormat)) {
                boolean success = false;
                int j2 = 0;
                while (j2 < desired.length) {
                    codec = SimpleGraphBuilder.findCodec(af, desired[j2], in, out);
                    if (codec != null) {
                        af = out[0];
                        codecList.addElement(codec);
                        this.formats[stages] = af;
                        ++stages;
                        success = true;
                        break;
                    }
                    ++j2;
                }
                if (success) break;
                codec = SimpleGraphBuilder.findCodec(af, ulawFormat, in, out);
                if (codec != null) {
                    codecList.addElement(codec);
                    af = out[0];
                    this.formats[stages] = af;
                    ++stages;
                    continue;
                }
                throw new UnsupportedFormatException(af);
            }
            codec = SimpleGraphBuilder.findCodec(af, linearFormat, in, out);
            if (codec != null) {
                codecList.addElement(codec);
                af = out[0];
                this.formats[stages] = af;
                ++stages;
                continue;
            }
            codec = SimpleGraphBuilder.findCodec(af, ulawFormat, in, out);
            if (codec != null) {
                codecList.addElement(codec);
                af = out[0];
                this.formats[stages] = af;
                ++stages;
                continue;
            }
            codec = SimpleGraphBuilder.findCodec(af, null, in, out);
            if (codec != null) {
                codecList.addElement(codec);
                af = out[0];
                this.formats[stages] = af;
                ++stages;
                continue;
            }
            throw new UnsupportedFormatException(af);
        }
        if (stages >= 4) {
            throw new UnsupportedFormatException(input);
        }
        this.finalFormat = out[0];
        this.codecs = new Codec[codecList.size()];
        this.buffers = new Buffer[codecList.size()];
        int sizePerSec = (int)(input.getSampleRate() * (double)input.getSampleSizeInBits() * (double)input.getChannels() / 8.0);
        int tmpsize = 0;
        int tmpBufSize = bufsize;
        int j3 = 0;
        while (j3 < codecList.size()) {
            this.codecs[j3] = (Codec)codecList.elementAt(j3);
            AudioFormat tmpff = (AudioFormat)this.formats[j3];
            tmpsize = (int)(tmpff.getSampleRate() * (double)tmpff.getSampleSizeInBits() * (double)tmpff.getChannels() / 8.0);
            sizePerSec = tmpsize;
            this.buffers[j3] = new Buffer();
            byte[] data = new byte[tmpBufSize *= tmpsize / sizePerSec];
            this.buffers[j3].setLength(tmpBufSize);
            this.buffers[j3].setOffset(0);
            this.buffers[j3].setFlags(0);
            this.buffers[j3].setFormat(this.formats[j3]);
            this.buffers[j3].setData(data);
            ++j3;
        }
    }

    public int process(Buffer buffer) {
        this.inputBuffer = buffer;
        return this.doProcess(0, buffer);
    }

    int doProcess(int num, Buffer inputBuffer) {
        if (num >= this.codecs.length) {
            return 0;
        }
        int retval = 0;
        try {
            retval = this.codecs[num].process(inputBuffer, this.buffers[num]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1;
        }
        catch (Error err) {
            err.printStackTrace();
            return 1;
        }
        if (retval == 1) {
            return 1;
        }
        return this.doProcess(num + 1, this.buffers[num]);
    }

    public Format getOutputFormat() {
        return this.finalFormat;
    }

    public Format getInputFormat() {
        return this.inputFormat;
    }

    public Buffer getOutputBuffer() {
        if (this.buffers != null && this.buffers.length > 0) {
            return this.buffers[this.buffers.length - 1];
        }
        return this.inputBuffer;
    }

    boolean match(AudioFormat af, AudioFormat[] fmt, AudioFormat[] in, AudioFormat[] out) {
        AudioFormat tmp = null;
        boolean found = false;
        int i2 = 0;
        while (i2 < fmt.length) {
            if (af.matches(fmt[i2]) && (tmp = (AudioFormat)af.intersects(fmt[i2])) != null) {
                out[0] = tmp;
                in[0] = af;
                found = true;
                break;
            }
            ++i2;
        }
        return found;
    }

    void setBufferSize(int bufsize) {
        int sizePerSec = (int)(this.inputFormat.getSampleRate() * (double)this.inputFormat.getSampleSizeInBits() * (double)this.inputFormat.getChannels() / 8.0);
        int tmpsize = 0;
        int tmpBufSize = bufsize;
        int j2 = 0;
        while (j2 < this.buffers.length) {
            AudioFormat tmpff = (AudioFormat)this.formats[j2];
            tmpsize = (int)(tmpff.getSampleRate() * (double)tmpff.getSampleSizeInBits() * (double)tmpff.getChannels() / 8.0);
            sizePerSec = tmpsize;
            this.buffers[j2] = new Buffer();
            byte[] data = new byte[tmpBufSize *= tmpsize / sizePerSec];
            this.buffers[j2].setLength(tmpBufSize);
            this.buffers[j2].setData(data);
            this.buffers[j2].setFormat(this.formats[j2]);
            ++j2;
        }
    }

    public Object clone() {
        AudioCodecPipe newpipe = new AudioCodecPipe();
        newpipe.formats = this.formats;
        newpipe.codecs = new Codec[this.codecs.length];
        int i2 = 0;
        while (i2 < this.codecs.length) {
            newpipe.codecs[i2] = this.codecs[i2];
            ++i2;
        }
        newpipe.buffers = new Buffer[this.codecs.length];
        newpipe.finalFormat = this.finalFormat;
        newpipe.inputFormat = this.inputFormat;
        newpipe.inputBuffer = this.inputBuffer;
        return newpipe;
    }
}

