/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.ColorTransform;
import com.sun.media.content.application.x_shockwave_flash.Flash;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.RColor;
import com.sun.media.content.application.x_shockwave_flash.REdge;
import com.sun.media.content.application.x_shockwave_flash.RRun;
import com.sun.media.content.application.x_shockwave_flash.Rect;
import com.sun.media.content.application.x_shockwave_flash.SCharacter;
import com.sun.media.content.application.x_shockwave_flash.SObject;
import com.sun.media.content.application.x_shockwave_flash.SParser;
import com.sun.media.content.application.x_shockwave_flash.ScriptPlayer;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;

final class DisplayList
implements ImageProducer {
    private Matrix cameraMat = new Matrix();
    private int backgroundColor = -1;
    private int backgroundColorPriority = 0;
    boolean antialias = false;
    private Rect devDirtyRgn = new Rect();
    private SObject objects;
    private Flash flash;
    SObject button = null;
    int buttonState = 0;
    private int buttonId = 0;
    static final int showAll = 0;
    static final int noBorder = 1;
    static final int exactFit = 2;
    static final int scaleMask = 15;
    static final int alignLeft = 16;
    static final int alignRight = 32;
    static final int alignTop = 64;
    static final int alignBottom = 128;
    boolean indexedColor;
    ColorModel model = null;
    private int width = 0;
    private int height = 0;
    private Rect bitClip;
    private Rect edgeClip;
    private int pixelSize = 0;
    private int pixelOrg;
    byte[] pixels8 = null;
    int[] pixels32 = null;
    private int topColorXleft;
    private RColor topColor;
    private RColor activeColors;
    private REdge[] activeEdges;
    private int nActive;
    private int maxActive;
    private REdge[] yindex;
    private int ylines;
    private int y;
    int bitY;
    private RRun firstRun;
    private RRun curRun;
    RRun runPool;
    private long rgb;
    private int pixelX;
    private int pixelW;
    private int pbufWidth;
    private int pbufTop;
    private int pbufNLines;
    private int pbufMaxLines;
    private int nColors;
    private int[] ctab;
    private byte[] itab;
    private int nEmpty;
    private int[] error;
    boolean forceCompleteScanlines = false;
    ImageConsumer theConsumer;
    boolean newConsumer;

    DisplayList(Flash flash) {
        this.flash = flash;
    }

    void FreeAll() {
        SObject obj = this.objects;
        while (obj != null) {
            this.devDirtyRgn.union(obj.devBounds);
            obj = obj.next;
        }
        this.objects = null;
        this.button = null;
        if (this.backgroundColorPriority <= 1) {
            this.backgroundColor = -1;
            this.backgroundColorPriority = 0;
        }
    }

    public synchronized void SetCamera(Rect frame, boolean smooth, int scaleMode, boolean updateNow) {
        int dstRefy;
        int srcRefy;
        int dstRefx;
        int srcRefx;
        Rect viewPort = new Rect(0, 0, this.width, this.height);
        if (smooth) {
            viewPort.xmax *= 4;
            viewPort.ymax *= 4;
        }
        Matrix newMat = new Matrix();
        newMat.a = Matrix.div(Math.max(viewPort.xmax - viewPort.xmin, 16), Math.max(frame.xmax - frame.xmin, 16));
        newMat.d = Matrix.div(Math.max(viewPort.ymax - viewPort.ymin, 16), Math.max(frame.ymax - frame.ymin, 16));
        switch (scaleMode & 0xF) {
            default: {
                newMat.a = newMat.d = Math.min(newMat.a, newMat.d);
                break;
            }
            case 1: {
                newMat.a = newMat.d = Math.max(newMat.a, newMat.d);
            }
        }
        if ((scaleMode & 0x10) != 0) {
            srcRefx = frame.xmin;
            dstRefx = viewPort.xmin;
        } else if ((scaleMode & 0x20) != 0) {
            srcRefx = frame.xmax;
            dstRefx = viewPort.xmax;
        } else {
            srcRefx = (frame.xmin + frame.xmax) / 2;
            dstRefx = (viewPort.xmin + viewPort.xmax) / 2;
        }
        if ((scaleMode & 0x40) != 0) {
            srcRefy = frame.ymin;
            dstRefy = viewPort.ymin;
        } else if ((scaleMode & 0x80) != 0) {
            srcRefy = frame.ymax;
            dstRefy = viewPort.ymax;
        } else {
            srcRefy = (frame.ymin + frame.ymax) / 2;
            dstRefy = (viewPort.ymin + viewPort.ymax) / 2;
        }
        newMat.tx = dstRefx - Matrix.mul(srcRefx, newMat.a);
        newMat.ty = dstRefy - Matrix.mul(srcRefy, newMat.a);
        if (newMat.a != this.cameraMat.a || newMat.b != this.cameraMat.b || newMat.c != this.cameraMat.c || newMat.d != this.cameraMat.d || newMat.tx != this.cameraMat.tx || newMat.ty != this.cameraMat.ty || this.antialias != smooth) {
            this.antialias = smooth;
            this.cameraMat = newMat;
            this.ModifyCamera();
        }
        if (updateNow) {
            this.Update();
        }
    }

    public synchronized void Invalidate() {
        this.devDirtyRgn.ymin = 0;
        this.devDirtyRgn.xmin = 0;
        this.devDirtyRgn.xmax = this.width;
        this.devDirtyRgn.ymax = this.height;
        if (this.antialias) {
            this.devDirtyRgn.xmax *= 4;
            this.devDirtyRgn.ymax *= 4;
        }
    }

    private void ModifyCamera() {
        this.Invalidate();
        SObject obj = this.objects;
        while (obj != null) {
            obj.ClearEdges();
            obj.devMat = Matrix.concat(obj.mat, this.cameraMat);
            obj.devBounds = obj.devMat.transform(obj.character.bounds);
            obj = obj.next;
        }
    }

    public synchronized void SetBackgroundColor(int color, int priority) {
        if (priority >= this.backgroundColorPriority) {
            if (this.backgroundColor == color && priority == this.backgroundColorPriority) {
                return;
            }
            this.Invalidate();
            this.backgroundColor = color;
            this.backgroundColorPriority = priority;
        }
    }

    public synchronized void PlaceObject(SCharacter ch, int id, Matrix mat, ColorTransform cx) {
        SObject obj = new SObject();
        obj.next = this.objects;
        this.objects = obj;
        obj.display = this;
        obj.character = ch;
        obj.id = id;
        obj.mat = mat;
        obj.cx = cx;
        if (ch.type == 2) {
            int state = 1;
            if (id == this.buttonId) {
                this.button = obj;
                state = this.buttonState;
            }
            this.UpdateButton(obj, state);
            obj.devBounds = new Rect();
        } else {
            obj.devMat = Matrix.concat(obj.mat, this.cameraMat);
            obj.devBounds = obj.devMat.transform(ch.bounds);
            this.devDirtyRgn.union(obj.devBounds);
        }
    }

    private SObject FindObject(int id) {
        SObject obj = this.objects;
        while (obj != null) {
            if (obj.id == id) {
                return obj;
            }
            obj = obj.next;
        }
        return null;
    }

    public synchronized void RemoveObject(int id) {
        SObject prev = null;
        SObject obj = this.objects;
        while (obj != null) {
            if (obj.id == id) {
                if (obj.buttonState != 0) {
                    this.UpdateButton(obj, 0);
                    this.RemoveObject(id);
                    if (this.button != obj) break;
                    this.button = null;
                    break;
                }
                if (obj.drawn) {
                    this.devDirtyRgn.union(obj.devBounds);
                }
                if (prev != null) {
                    prev.next = obj.next;
                    break;
                }
                this.objects = obj.next;
                break;
            }
            prev = obj;
            obj = obj.next;
        }
    }

    private void UpdateButton(SObject obj, int newState) {
        int oldState = obj.buttonState;
        if (oldState == newState) {
            return;
        }
        ScriptPlayer player = obj.character.player;
        SParser parser = new SParser();
        int cxPos = obj.character.cxformPos;
        ColorTransform cx = null;
        SParser cxParser = null;
        if (cxPos > 0) {
            cxParser = new SParser();
        }
        int pass = 0;
        while (pass < 2) {
            int stateFlags;
            parser.Attach(player.script, obj.character.dataPos);
            if (cxParser != null) {
                cxParser.Attach(player.script, cxPos);
            }
            while ((stateFlags = parser.GetByte()) != 0) {
                boolean oldVis;
                int tag = parser.GetWord();
                int depth = (obj.id & 0xFFFF) + parser.GetWord();
                Matrix m2 = parser.GetMatrix();
                int id = tag << 16 | depth;
                if (cxPos > 0) {
                    cx = new ColorTransform();
                    cxParser.GetColorTransform(cx);
                }
                boolean newVis = (stateFlags & newState) != 0;
                boolean bl = oldVis = (stateFlags & oldState) != 0;
                if (pass == 1 && newVis && !oldVis) {
                    SCharacter ch = player.FindCharacter(tag);
                    if (ch == null) continue;
                    this.PlaceObject(ch, id, Matrix.concat(m2, obj.mat), cx);
                    continue;
                }
                if (pass != 0 || newVis || !oldVis) continue;
                this.RemoveObject(id);
            }
            obj.buttonState = newState;
            ++pass;
        }
    }

    public synchronized boolean SetButtonState(SObject newButton, int newState) {
        boolean changed = false;
        if (newButton != this.button) {
            if (this.button != null) {
                this.button.character.player.PlayButtonSound(this.button, 1);
                this.UpdateButton(this.button, 1);
                changed = true;
            }
            this.button = newButton;
            if (this.button != null) {
                this.button.character.player.PlayButtonSound(this.button, newState);
                this.UpdateButton(this.button, newState);
                changed = true;
            }
        } else if (this.button != null && this.button.buttonState != newState) {
            this.button.character.player.PlayButtonSound(this.button, newState);
            this.UpdateButton(this.button, newState);
            changed = true;
        }
        if (this.button != null) {
            this.buttonState = newState;
            this.buttonId = this.button.id;
        } else {
            this.buttonId = 0;
        }
        return changed;
    }

    public synchronized SObject HitButton(int x, int y) {
        SObject hitObj = null;
        int hitTag = 0;
        SObject obj = this.objects;
        while (obj != null) {
            if (obj.character.type == 2 && obj.id > hitTag && this.HitOneButton(obj, x, y)) {
                hitObj = obj;
                hitTag = obj.id;
            }
            obj = obj.next;
        }
        return hitObj;
    }

    public synchronized boolean HitOneButton(SObject obj, int x, int y) {
        int stateFlags;
        Point pt = new Point(x, y);
        if (this.antialias) {
            pt.x *= 4;
            pt.y *= 4;
        }
        ScriptPlayer player = obj.character.player;
        SParser parser = new SParser();
        parser.Attach(player.script, obj.character.dataPos);
        while ((stateFlags = parser.GetByte()) != 0) {
            SCharacter ch;
            int tag = parser.GetWord();
            int depth = obj.id + parser.GetWord();
            Matrix m2 = parser.GetMatrix();
            int id = tag << 16 | depth;
            if ((stateFlags & 8) == 0 || (ch = player.FindCharacter(tag)) == null) continue;
            SObject child = new SObject();
            child.display = this;
            child.character = ch;
            child.id = id;
            child.mat = Matrix.concat(m2, obj.mat);
            child.devMat = Matrix.concat(child.mat, this.cameraMat);
            child.devBounds = child.devMat.transform(ch.bounds);
            if (!child.HitTest(pt)) continue;
            return true;
        }
        return false;
    }

    private final void PixelInit() {
        this.rgb = 0L;
        this.pixelW = 0;
        this.pixelX = -32000;
    }

    private final void PixelPaint() {
        if (this.pixelW > 0) {
            this.DrawPixel(this.pixelX, this.rgb, this.pixelW);
            this.rgb = 0L;
            this.pixelW = 0;
        }
    }

    private final void PixelAdd(long wideColor, int yw, int px, int xw) {
        if (this.pixelX != px) {
            this.PixelPaint();
            this.pixelX = px;
        }
        this.rgb += (long)xw * wideColor;
        this.pixelW += xw * yw;
    }

    static final long ExpandColor(int color) {
        return ((long)color & 0xFF000000L) << 24 | ((long)color & 0xFF0000L) << 16 | ((long)color & 0xFF00L) << 8 | (long)color & 0xFFL;
    }

    static final int PackColor(long color) {
        return (int)(color >> 24) & 0xFF000000 | (int)(color >> 16) & 0xFF0000 | (int)(color >> 8) & 0xFF00 | (int)color & 0xFF;
    }

    private final void DrawPixel(int x, long wideColor, int coverage) {
        this.SetPixel(x, DisplayList.PackColor(wideColor / 16L));
    }

    private final void SetPixel(int x, int color) {
        if (this.indexedColor) {
            this.pixels8[x + this.pixelOrg] = (byte)this.RGBToIndex(color);
        } else {
            this.pixels32[x + this.pixelOrg] = color;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void DrawSlab(int xmin, int xmax, RColor color) {
        if (xmin < this.bitClip.xmin) {
            xmin = this.bitClip.xmin;
        }
        if (xmax > this.bitClip.xmax) {
            xmax = this.bitClip.xmax;
        }
        switch (color.fillType) {
            case 64: 
            case 65: 
            case 66: {
                color.bitmap.DrawSlab(this.pixelOrg, xmin, xmax, color);
                break;
            }
            case 0: {
                i = xmin + this.pixelOrg;
                n = xmax - xmin;
                if (i + n > this.pixelSize) {
                    return;
                }
                if (!this.indexedColor) ** GOTO lbl20
                while (n-- > 0) {
                    this.pixels8[i++] = color.index;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    this.pixels32[i++] = color.color;
lbl20:
                    // 2 sources

                    ** while (n-- > 0)
                }
lbl21:
                // 1 sources

                break;
            }
            case 16: {
                pt = new Point(xmin << 8, this.bitY << 8);
                color.ginvMat.transform(pt);
                dx = color.ginvMat.a >> 8;
                dy = color.ginvMat.b >> 8;
                x = xmin;
                while (x < xmax) {
                    i = (pt.x >> 15) + 128;
                    if (i > 256) {
                        i = 256;
                    } else if (i < 0) {
                        i = 0;
                    }
                    this.SetPixel(x, color.gcolorRamp[i]);
                    pt.x += dx;
                    pt.y += dy;
                    ++x;
                }
                break;
            }
            case 18: {
                pt = new Point(xmin << 8, this.bitY << 8);
                color.ginvMat.transform(pt);
                dx = color.ginvMat.a >> 8;
                dy = color.ginvMat.b >> 8;
                step = 0;
                i = Matrix.length(pt.x, pt.y) >> 14;
                if (i > 256) {
                    i = 256;
                }
                x = xmin;
                while (x < xmax) {
                    t = pt.x >> 14;
                    i2 = t * t;
                    t = pt.y >> 14;
                    i2 += t * t;
                    previ = i;
                    if ((i += step) < 0) {
                        i = 0;
                    } else if (i > 256) {
                        i = 256;
                    }
                    while (true) {
                        if (i2 < i * i) {
                            --i;
                            continue;
                        }
                        if (i2 <= (i + 1) * (i + 1) || i >= 256) break;
                        ++i;
                    }
                    step = i - previ;
                    this.SetPixel(x, color.gcolorRamp[i]);
                    pt.x += dx;
                    pt.y += dy;
                    ++x;
                }
                break;
            }
        }
    }

    private final void UpdateColor(int x) {
        RColor top = null;
        RColor prev = null;
        RColor c2 = this.activeColors;
        while (c2 != null) {
            if (c2.visible != 0) {
                if (top == null || c2.order > top.order) {
                    top = c2;
                }
                prev = c2;
            } else {
                if (prev != null) {
                    prev.nextActive = c2.nextActive;
                } else {
                    this.activeColors = c2.nextActive;
                }
                c2.onActiveList = false;
            }
            c2 = c2.nextActive;
        }
        if (this.topColor != top) {
            if (this.topColor != null) {
                if (this.antialias) {
                    this.PaintAASlab(this.topColorXleft, x);
                } else {
                    this.DrawSlab(this.topColorXleft, x, this.topColor);
                }
            }
            this.topColor = top;
            this.topColorXleft = x;
        }
    }

    private final void ShowColor(RColor c2, int x) {
        if (this.topColor != null) {
            if (c2.order > this.topColor.order) {
                if (this.antialias) {
                    this.PaintAASlab(this.topColorXleft, x);
                } else {
                    this.DrawSlab(this.topColorXleft, x, this.topColor);
                }
                this.topColor = c2;
                this.topColorXleft = x;
            }
        } else {
            this.topColor = c2;
            this.topColorXleft = x;
        }
        if (!c2.onActiveList) {
            c2.onActiveList = true;
            c2.nextActive = this.activeColors;
            this.activeColors = c2;
        }
    }

    private final void HideColor(RColor c2, int x) {
        if (c2 == this.topColor) {
            this.UpdateColor(x);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void PaintAASlab(int xleft, int xright) {
        r = this.curRun;
        if (r != null && r.xmin < xright) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            r = r.next;
            if (r != null) continue;
            this.curRun = null;
            return;
lbl8:
            // 2 sources

            ** while (r.xmax < xleft)
        }
lbl9:
        // 1 sources

        if (r.xmin < xleft) {
            r = r.Split(this, xleft);
        }
        while (r != null && r.xmin < xright) {
            if (r.xmax > xright) {
                this.curRun = r.Split(this, xright);
                r.AddColor(this.topColor);
                return;
            }
            r.AddColor(this.topColor);
            r = r.next;
        }
        this.curRun = r;
    }

    private final void PaintAARuns() {
        this.bitY = this.y / 4;
        this.PixelInit();
        RRun r = this.firstRun;
        while (true) {
            if (r.nColors > 0) {
                if (r.isPure && r.nColors == 4) {
                    RRun next;
                    while ((next = r.next) != null && next.isPure && next.colors[0] == r.colors[0] && next.nColors >= 4) {
                        r.xmax = next.xmax;
                        r.next = next.next;
                    }
                }
                int xl = r.xmin / 4;
                int xlf = r.xmin & 3;
                int xr = r.xmax / 4;
                int xrf = r.xmax & 3;
                long runRGB = r.CalcColor(xl, this.bitY);
                if (xl == xr) {
                    this.PixelAdd(runRGB, r.nColors, xl, xrf - xlf);
                } else {
                    if (xlf > 0) {
                        this.PixelAdd(runRGB, r.nColors, xl, 4 - xlf);
                        ++xl;
                    }
                    if (xl < xr) {
                        long rgb;
                        int j2;
                        int rw;
                        if (r.isPure && r.nColors == 4) {
                            this.DrawSlab(xl, xr, r.colors[0]);
                        } else if (r.isComplex) {
                            rw = 4 * r.nColors;
                            j2 = xl;
                            while (j2 < xr) {
                                rgb = r.CalcColor(j2, this.bitY) * 4L;
                                this.DrawPixel(j2, rgb, rw);
                                ++j2;
                            }
                        } else {
                            rgb = 4L * runRGB;
                            rw = 4 * r.nColors;
                            j2 = xl;
                            while (j2 < xr) {
                                this.DrawPixel(j2, rgb, rw);
                                ++j2;
                            }
                        }
                    }
                    if (xrf > 0) {
                        if (r.isComplex) {
                            runRGB = r.CalcColor(xr, this.bitY);
                        }
                        this.PixelAdd(runRGB, r.nColors, xr, xrf);
                    }
                }
            }
            if (r.next == null) break;
            r = r.next;
        }
        r.next = this.runPool;
        this.runPool = this.firstRun;
        this.firstRun = null;
        this.PixelPaint();
    }

    private final void AddEdges(REdge edge) {
        while (edge != null) {
            if (edge.anchor1y <= this.edgeClip.ymax && edge.anchor2y > this.edgeClip.ymin) {
                int i2 = edge.anchor1y - this.edgeClip.ymin;
                if (i2 < 0) {
                    i2 = 0;
                }
                edge.nextActive = this.yindex[i2];
                this.yindex[i2] = edge;
            }
            edge = edge.nextObj;
        }
    }

    private final void InitPixels() {
        this.pixelOrg = -this.bitClip.xmin;
        this.pbufWidth = this.bitClip.xmax - this.bitClip.xmin;
        this.pbufNLines = 0;
        this.pbufMaxLines = this.pixelSize / this.pbufWidth;
        this.pbufTop = this.bitClip.ymin;
    }

    private final void AdvanceLine() {
        ++this.pbufNLines;
        if (this.pbufNLines >= this.pbufMaxLines) {
            this.SendPixels();
        }
        this.pixelOrg = this.pbufNLines * this.pbufWidth - this.bitClip.xmin;
    }

    private final void SendPixels() {
        if (this.pbufNLines > 0) {
            if (this.indexedColor) {
                this.theConsumer.setPixels(this.bitClip.xmin, this.pbufTop, this.pbufWidth, this.pbufNLines, this.model, this.pixels8, 0, this.pbufWidth);
            } else {
                this.theConsumer.setPixels(this.bitClip.xmin, this.pbufTop, this.pbufWidth, this.pbufNLines, this.model, this.pixels32, 0, this.pbufWidth);
            }
        }
        this.pbufTop += this.pbufNLines;
        this.pbufNLines = 0;
    }

    private final void PaintBits() {
        this.InitPixels();
        this.y = this.edgeClip.ymin;
        while (this.y < this.edgeClip.ymax) {
            int i2;
            boolean swapped;
            REdge e2 = this.yindex[this.y - this.edgeClip.ymin];
            while (e2 != null) {
                e2.initStep(this.y);
                if (this.nActive == this.maxActive) {
                    this.maxActive *= 2;
                    REdge[] newActive = new REdge[this.maxActive];
                    System.arraycopy(this.activeEdges, 0, newActive, 0, this.nActive);
                    this.activeEdges = newActive;
                }
                int i3 = this.nActive;
                while (true) {
                    if (i3 == 0 || this.activeEdges[i3 - 1].x < e2.x) break;
                    this.activeEdges[i3] = this.activeEdges[i3 - 1];
                    --i3;
                }
                this.activeEdges[i3] = e2;
                ++this.nActive;
                e2 = e2.nextActive;
            }
            int end = this.nActive - 1;
            do {
                swapped = false;
                i2 = 0;
                while (i2 < end) {
                    if (this.activeEdges[i2].x > this.activeEdges[i2 + 1].x) {
                        REdge tmp = this.activeEdges[i2];
                        this.activeEdges[i2] = this.activeEdges[i2 + 1];
                        this.activeEdges[i2 + 1] = tmp;
                        if (!swapped && i2 > 0 && this.activeEdges[i2 - 1].x > this.activeEdges[i2].x) {
                            swapped = true;
                        }
                    }
                    ++i2;
                }
            } while (swapped && --end > 0);
            if (this.antialias) {
                if (this.firstRun == null) {
                    if (this.runPool != null) {
                        this.firstRun = this.runPool;
                        this.runPool = this.firstRun.next;
                        this.firstRun.next = null;
                        this.firstRun.nColors = 0;
                        this.firstRun.isComplex = false;
                        this.firstRun.isPure = true;
                    } else {
                        this.firstRun = new RRun();
                    }
                    this.firstRun.xmin = this.edgeClip.xmin;
                    this.firstRun.xmax = this.edgeClip.xmax;
                }
                this.curRun = this.firstRun;
            } else {
                this.bitY = this.y;
            }
            int destActive = 0;
            int ynext = this.y + 1;
            i2 = 0;
            while (i2 < this.nActive) {
                REdge a2 = this.activeEdges[i2];
                switch (a2.fillRule) {
                    case 0: {
                        RColor c2 = a2.color1;
                        if (c2.visible != 0) {
                            c2.visible = 0;
                            this.HideColor(c2, a2.x);
                        } else {
                            c2.visible = 1;
                            this.ShowColor(c2, a2.x);
                        }
                        c2 = a2.color2;
                        if (c2.visible != 0) {
                            c2.visible = 0;
                            this.HideColor(c2, a2.x);
                            break;
                        }
                        c2.visible = 1;
                        this.ShowColor(c2, a2.x);
                        break;
                    }
                    case 1: {
                        RColor c2 = a2.color1;
                        if (c2.visible != 0) {
                            c2.visible = 0;
                            this.HideColor(c2, a2.x);
                            break;
                        }
                        c2.visible = 1;
                        this.ShowColor(c2, a2.x);
                        break;
                    }
                    case 2: {
                        RColor c2 = a2.color1;
                        if (c2.visible == 0) {
                            c2.visible += a2.dir;
                            this.ShowColor(c2, a2.x);
                            break;
                        }
                        c2.visible += a2.dir;
                        if (c2.visible != 0) break;
                        this.HideColor(c2, a2.x);
                    }
                }
                if (a2.anchor2y > ynext) {
                    a2.Step(ynext);
                    this.activeEdges[destActive] = a2;
                    ++destActive;
                }
                ++i2;
            }
            this.nActive = destActive;
            if (this.antialias) {
                if ((this.y & 3) == 3) {
                    this.PaintAARuns();
                    if (this.theConsumer == null) {
                        return;
                    }
                    this.AdvanceLine();
                }
            } else {
                if (this.theConsumer == null) {
                    return;
                }
                this.AdvanceLine();
            }
            ++this.y;
        }
        if (this.theConsumer != null) {
            this.SendPixels();
        }
        this.runPool = null;
    }

    final int IndexToRGB(int index) {
        return this.ctab[index];
    }

    final int RGBToIndex(int rgb) {
        int i2 = (rgb & 0xF00000) >> 12 | (rgb & 0xF000) >> 8 | (rgb & 0xF0) >> 4;
        return this.itab[i2] & 0xFF;
    }

    private final int ColorDist(int a2, int b2) {
        int e2 = a2 - b2;
        return e2 < 0 ? -e2 : e2;
    }

    private final void FillCube(int color, int index, int d2) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int ri = red >> 4;
        int gi = green >> 4;
        int bi = blue >> 4;
        int rmin = Math.max(0, ri - d2);
        int rmax = Math.min(15, ri + d2);
        int gmin = Math.max(0, gi - d2);
        int gmax = Math.min(15, gi + d2);
        int bmin = Math.max(0, bi - d2);
        int bmax = Math.min(15, bi + d2);
        ri = rmin;
        while (ri <= rmax) {
            int r = ri == 15 ? 255 : ri << 4;
            gi = gmin;
            while (gi <= gmax) {
                int g2 = gi == 15 ? 255 : gi << 4;
                int errG = this.ColorDist(r, red) + this.ColorDist(g2, green);
                int iG = ri << 8 | gi << 4;
                bi = bmin;
                while (bi <= bmax) {
                    int b2 = bi == 15 ? 255 : bi << 4;
                    int i2 = iG | bi;
                    int err = errG + this.ColorDist(b2, blue);
                    if (err < this.error[i2]) {
                        if (this.error[i2] == 50000) {
                            --this.nEmpty;
                        }
                        this.error[i2] = err;
                        this.itab[i2] = (byte)index;
                    }
                    ++bi;
                }
                ++gi;
            }
            ++ri;
        }
    }

    private final void BuildInverseTable() {
        if (this.itab == null || this.error == null) {
            this.itab = new byte[4096];
            this.error = new int[4096];
        }
        int i2 = 0;
        while (i2 < 4096) {
            this.error[i2] = 50000;
            ++i2;
        }
        this.nEmpty = 4096;
        int d2 = 3;
        while (d2 < 16 && this.nEmpty > 0) {
            int i3 = 0;
            while (i3 < this.nColors) {
                this.FillCube(this.ctab[i3], i3, d2);
                ++i3;
            }
            ++d2;
        }
        this.error = null;
    }

    public synchronized boolean UpdateImageSize(int w, int h2) {
        if (w != this.width || h2 != this.height) {
            this.SetImage(w, h2, this.model);
            return true;
        }
        return false;
    }

    public synchronized void SetImage(int w, int h2, ColorModel m2) {
        this.model = m2;
        this.width = w;
        this.height = h2;
        this.Invalidate();
        if (this.model instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)this.model;
            this.nColors = icm.getMapSize();
            byte[] ctabRed = new byte[this.nColors];
            byte[] ctabGreen = new byte[this.nColors];
            byte[] ctabBlue = new byte[this.nColors];
            icm.getReds(ctabRed);
            icm.getGreens(ctabGreen);
            icm.getBlues(ctabBlue);
            this.ctab = new int[this.nColors];
            int nWhite = 0;
            int i2 = 0;
            while (i2 < this.nColors) {
                this.ctab[i2] = 0xFF000000 | (ctabRed[i2] & 0xFF) << 16 | (ctabGreen[i2] & 0xFF) << 8 | ctabBlue[i2] & 0xFF;
                if (this.ctab[i2] == -1) {
                    ++nWhite;
                }
                ++i2;
            }
            if (nWhite > 100) {
                this.forceCompleteScanlines = true;
                this.SetImage(w, h2, ColorModel.getRGBdefault());
                return;
            }
            this.indexedColor = true;
            this.BuildInverseTable();
            if (this.pixels8 == null || this.pixelSize < 4 * this.width) {
                this.pixelSize = this.width * this.height;
                if (this.pixelSize > 100000 && !this.flash.allocateFullClug) {
                    this.pixelSize = 100000;
                }
                this.pixels8 = new byte[this.pixelSize];
                this.pixels32 = null;
            }
        } else {
            this.model = ColorModel.getRGBdefault();
            this.indexedColor = false;
            if (this.pixels32 == null || this.pixelSize < 4 * this.width) {
                this.pixelSize = this.width * this.height;
                if (this.pixelSize > 50000 && !this.flash.allocateFullClug) {
                    this.pixelSize = 50000;
                }
                this.pixels8 = null;
                this.pixels32 = new int[this.pixelSize];
            }
            this.ctab = null;
            this.itab = null;
        }
    }

    boolean Update() {
        if (!this.devDirtyRgn.isEmpty()) {
            this.produce(true);
            return true;
        }
        return false;
    }

    synchronized void gotoFrame(ScriptPlayer player, int frameNum) {
        player.mute = true;
        player.nActions = 0;
        player.DrawFrame(frameNum - 1);
        player.mute = false;
        player.nActions = 0;
        player.DrawFrame(frameNum);
    }

    synchronized int drawFrame(ScriptPlayer player, int frameNum) {
        return player.DrawFrame(frameNum);
    }

    public synchronized void addConsumer(ImageConsumer ic) {
        if (ic != this.theConsumer) {
            this.theConsumer = ic;
            this.newConsumer = true;
        }
    }

    public boolean isConsumer(ImageConsumer ic) {
        return this.theConsumer == ic;
    }

    public synchronized void removeConsumer(ImageConsumer ic) {
        if (this.theConsumer == ic) {
            this.theConsumer = null;
        }
    }

    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
        this.produce(false);
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    private synchronized void produce(boolean partialUpdateOK) {
        if (this.theConsumer == null) {
            this.flash.CauseUpdate(0, 0, 500, 500);
            this.flash.repaint();
            if (Thread.currentThread().getName().indexOf("Flash Player thread") >= 0) {
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return;
        }
        if (this.newConsumer) {
            this.theConsumer.setDimensions(this.width, this.height);
            if (this.theConsumer == null) {
                return;
            }
            this.theConsumer.setColorModel(this.model);
            if (this.theConsumer == null) {
                return;
            }
            int hints = 10;
            this.theConsumer.setHints(hints);
            this.newConsumer = false;
        }
        if (this.theConsumer == null) {
            return;
        }
        if (!partialUpdateOK) {
            this.bitClip = new Rect(0, 0, this.width, this.height);
        } else {
            this.bitClip = new Rect(this.devDirtyRgn);
            if (this.antialias) {
                this.bitClip.xmin /= 4;
                this.bitClip.ymin /= 4;
                this.bitClip.xmax /= 4;
                this.bitClip.ymax /= 4;
            }
            this.bitClip.xmin -= 2;
            this.bitClip.xmax += 2;
            this.bitClip.ymin -= 2;
            this.bitClip.ymax += 2;
            this.bitClip.xmin = Math.max(this.bitClip.xmin, 0);
            this.bitClip.xmax = Math.min(this.bitClip.xmax, this.width);
            this.bitClip.ymin = Math.max(this.bitClip.ymin, 0);
            this.bitClip.ymax = Math.min(this.bitClip.ymax, this.height);
            if (this.bitClip.xmin >= this.bitClip.xmax || this.bitClip.ymin >= this.bitClip.ymax) {
                this.bitClip.setEmpty();
            }
        }
        this.devDirtyRgn.setEmpty();
        if (!this.bitClip.isEmpty()) {
            if (this.forceCompleteScanlines) {
                this.bitClip.xmin = 0;
                this.bitClip.xmax = this.width;
            }
            if (this.antialias) {
                this.edgeClip = new Rect(this.bitClip);
                this.edgeClip.xmin *= 4;
                this.edgeClip.xmax *= 4;
                this.edgeClip.ymin *= 4;
                this.edgeClip.ymax *= 4;
            } else {
                this.edgeClip = this.bitClip;
            }
            this.ylines = this.edgeClip.ymax - this.edgeClip.ymin + 1;
            this.yindex = new REdge[this.ylines];
            if (this.activeEdges == null) {
                this.maxActive = 250;
                this.activeEdges = new REdge[this.maxActive];
            }
            this.nActive = 0;
            this.activeColors = null;
            this.topColor = null;
            this.topColorXleft = 0;
            SObject obj = this.objects;
            while (obj != null) {
                if (obj.devBounds.testIntersect(this.edgeClip)) {
                    obj.BuildEdges();
                    obj.drawn = true;
                    this.AddEdges(obj.edges);
                }
                obj = obj.next;
            }
            if (this.backgroundColor != 0) {
                REdge bkEdge0 = new REdge();
                REdge bkEdge1 = new REdge();
                RColor bkColor = new RColor(this, this.backgroundColor);
                bkColor.order = 0;
                bkEdge0.nextObj = bkEdge1;
                Point pt1 = new Point(this.edgeClip.xmin, this.edgeClip.ymin);
                Point pt2 = new Point(this.edgeClip.xmin, this.edgeClip.ymax);
                bkEdge0.set(pt1, pt2);
                pt1.x = pt2.x = this.edgeClip.xmax;
                bkEdge1.set(pt1, pt2);
                bkEdge1.fillRule = 1;
                bkEdge0.fillRule = 1;
                bkEdge0.color1 = bkEdge1.color1 = bkColor;
                this.AddEdges(bkEdge0);
            }
            this.PaintBits();
            this.theConsumer.imageComplete(2);
            this.flash.updateImageToScreeen(true, this.bitClip.xmin, this.bitClip.ymin, this.bitClip.xmax - this.bitClip.xmin + 1, this.bitClip.ymax - this.bitClip.ymin + 1);
        }
    }
}

