/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Bitmap;
import com.sun.media.content.application.x_shockwave_flash.DisplayList;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.RColor;
import java.awt.Point;

class RRun {
    RRun next;
    int xmin;
    int xmax;
    RColor[] colors = new RColor[4];
    int nColors;
    boolean isComplex;
    boolean isPure = true;

    RRun() {
    }

    final void AddColor(RColor rc) {
        this.colors[this.nColors] = rc;
        ++this.nColors;
        if (rc != this.colors[0]) {
            this.isPure = false;
        }
        if (rc.fillType != 0) {
            this.isComplex = true;
        }
    }

    final long CalcColor(int x, int y) {
        if (this.isComplex) {
            long wideColor = 0L;
            RColor cacheC = null;
            long cacheRGB = 0L;
            int i2 = 0;
            while (i2 < this.nColors) {
                RColor rc = this.colors[i2];
                if (rc.fillType != 0) {
                    if (cacheC != rc) {
                        switch (rc.fillType) {
                            case 64: 
                            case 65: 
                            case 66: {
                                Bitmap bitmap = rc.bitmap;
                                Point pt = new Point(x << 16, y << 16);
                                rc.bmInvMat.transform(pt);
                                cacheRGB = rc.fillType == 65 ? (rc.bmSmooth ? DisplayList.ExpandColor(bitmap.GetSSRGBPixel(pt.x - 32768, pt.y - 32768)) : DisplayList.ExpandColor(bitmap.GetRGBPixel(pt.x >> 16, pt.y >> 16))) : DisplayList.ExpandColor(bitmap.GetRGBPixel(Bitmap.LimitAbsI(pt.x >> 16, bitmap.width), Bitmap.LimitAbsI(pt.y >> 16, bitmap.height)));
                                cacheC = rc;
                                break;
                            }
                            case 16: {
                                Point pt = new Point(x << 8, y << 8);
                                rc.ginvMat.transform(pt);
                                int intensity = (pt.x >> 15) + 128;
                                if (intensity > 256) {
                                    intensity = 256;
                                } else if (intensity < 0) {
                                    intensity = 0;
                                }
                                cacheRGB = DisplayList.ExpandColor(rc.gcolorRamp[intensity]);
                                cacheC = rc;
                                break;
                            }
                            case 18: {
                                Point pt = new Point(x << 8, y << 8);
                                rc.ginvMat.transform(pt);
                                int intensity = Matrix.length(pt.x, pt.y) >> 14;
                                if (intensity > 256) {
                                    intensity = 256;
                                }
                                cacheRGB = DisplayList.ExpandColor(rc.gcolorRamp[intensity]);
                                cacheC = rc;
                            }
                        }
                    }
                    wideColor += cacheRGB;
                } else {
                    wideColor += rc.wideColor;
                }
                ++i2;
            }
            return wideColor;
        }
        if (this.isPure) {
            if (this.nColors == 4) {
                return 4L * this.colors[0].wideColor;
            }
            return (long)this.nColors * this.colors[0].wideColor;
        }
        long wideColor = 0L;
        int i3 = 0;
        while (i3 < this.nColors) {
            wideColor += this.colors[i3].wideColor;
            ++i3;
        }
        return wideColor;
    }

    final RRun Split(DisplayList raster, int x) {
        RRun n2 = raster.runPool;
        if (n2 != null) {
            raster.runPool = n2.next;
        } else {
            n2 = new RRun();
        }
        n2.xmin = x;
        n2.xmax = this.xmax;
        this.xmax = x;
        n2.next = this.next;
        this.next = n2;
        n2.colors[0] = this.colors[0];
        n2.colors[1] = this.colors[1];
        n2.colors[2] = this.colors[2];
        n2.colors[3] = this.colors[3];
        n2.nColors = this.nColors;
        n2.isComplex = this.isComplex;
        n2.isPure = this.isPure;
        return n2;
    }
}

