/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.FlashAudioPlayer;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import java.applet.AudioClip;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class Sound
implements AudioClip {
    static final int sndMono = 0;
    static final int sndStereo = 1;
    static final int snd8Bit = 0;
    static final int snd16Bit = 2;
    static final int snd5K = 0;
    static final int snd11K = 4;
    static final int intsnd22K = 8;
    static final int intsnd44K = 12;
    static final int sndCompressNone = 0;
    static final int sndCompressADPCM = 16;
    static final int sndRateMask = 12;
    static final int sndCompressMask = 240;
    private int format;
    private int srcSamples;
    private int dstSamples;
    private byte[] srcData;
    private int srcDataStart;
    private int srcDataPos;
    private boolean stereo;
    private boolean dataIsValid;
    private byte[] mulawData;
    Sound next;
    int characterTag;
    static final int sndRate5K_2X = 11025;
    static final int sndRate8K_2X = 16000;
    static final int sndRate11K_2X = 22050;
    static final int sndRate22K_2X = 44100;
    static final int sndRate44K_2X = 88200;
    static final int[] kRateTable = new int[]{11025, 22050, 44100, 88200};
    static final int[] kRateShiftTable = new int[]{3, 2, 1, 0};
    private static final int kNextTag = 779316836;
    private static final int kSndFormatMulaw8 = 1;
    private static final int kHeaderSize = 28;
    private static final int kMuLawZero = 2;
    private static final int kMuLawBias = 132;
    private static byte[] mulawExpTable;
    int bitBuf;
    int bitPos;
    int nBits;
    int nSamples;
    int[] valpred = new int[2];
    int[] index = new int[2];
    static final int[] indexTable2;
    static final int[] indexTable3;
    static final int[] indexTable4;
    static final int[] indexTable5;
    static final int[][] indexTables;
    static final int[] stepsizeTable;

    int Rate2X() {
        return kRateTable[this.format >> 2 & 3];
    }

    int RateShift() {
        return kRateShiftTable[this.format >> 2 & 3];
    }

    boolean Stereo() {
        return (this.format & 1) != 0;
    }

    int NChannels() {
        return (this.format & 1) != 0 ? 2 : 1;
    }

    boolean Is8Bit() {
        return (this.format & 2) == 0;
    }

    int BitsPerSample() {
        return (this.format & 2) != 0 ? 16 : 8;
    }

    int BytesPerSample() {
        return (this.format & 2) != 0 ? 2 : 1;
    }

    int CompressFormat() {
        return this.format & 0xF0;
    }

    boolean Compressed() {
        return (this.format & 0xF0) != 0;
    }

    Sound(int format, int srcSamples, byte[] data, int start) {
        this.format = format;
        this.srcSamples = srcSamples;
        this.srcData = data;
        this.srcDataStart = this.srcDataPos = start;
        this.stereo = this.Stereo();
        this.CreateMulawTable();
        switch (this.Rate2X()) {
            case 11025: {
                this.dstSamples = (int)(((long)srcSamples * 16000L + 11024L) / 11025L);
                break;
            }
            case 22050: {
                this.dstSamples = (int)(((long)srcSamples * 16000L + 22049L) / 22050L);
                break;
            }
            case 44100: {
                this.dstSamples = (int)(((long)srcSamples * 16000L + 44099L) / 44100L);
                break;
            }
            case 88200: {
                this.dstSamples = (int)(((long)srcSamples * 16000L + 88199L) / 88200L);
            }
        }
    }

    void SetFormat(int format) {
        this.format = format;
        this.stereo = this.Stereo();
    }

    void SetSamples(int srcSamples) {
        this.srcSamples = srcSamples;
        switch (this.Rate2X()) {
            case 11025: {
                this.dstSamples = (int)(((long)srcSamples * 16000L + 11024L) / 11025L);
                break;
            }
            case 22050: {
                this.dstSamples = (int)(((long)srcSamples * 16000L + 22049L) / 22050L);
                break;
            }
            case 44100: {
                this.dstSamples = (int)(((long)srcSamples * 16000L + 44099L) / 44100L);
                break;
            }
            case 88200: {
                this.dstSamples = (int)(((long)srcSamples * 16000L + 88199L) / 88200L);
            }
        }
    }

    public synchronized void play(int loopCount) {
        this.stop();
        if (this.mulawData != null) {
            FlashAudioPlayer.player.start(this.mulawData, loopCount);
        }
    }

    public synchronized void play() {
        this.play(1);
    }

    synchronized void playMultiple(int loopCount) {
        if (this.mulawData != null) {
            FlashAudioPlayer.player.start(this.mulawData, loopCount);
        }
    }

    synchronized void playMultiple() {
        this.playMultiple(1);
    }

    synchronized void playNoMultiple(int loopCount) {
        if (FlashAudioPlayer.player.getActiveSoundNum() != 0) {
            return;
        }
        this.stop();
        if (this.mulawData != null) {
            FlashAudioPlayer.player.start(this.mulawData, loopCount);
        }
    }

    synchronized void playNoMultiple() {
        this.playMultiple(1);
    }

    public synchronized void loop() {
        this.stop();
        if (this.mulawData != null) {
            FlashAudioPlayer.player.start(this.mulawData, -1);
        }
    }

    public synchronized void stop() {
        FlashAudioPlayer.player.stop();
    }

    synchronized boolean ConvertToMulaw(int loopcount) {
        if (this.dataIsValid) {
            return true;
        }
        this.mulawData = this.DecompressFromADPCMAndResample();
        if (this.mulawData != null) {
            ByteArrayOutputStream header = new ByteArrayOutputStream(28);
            DataOutputStream headerOut = new DataOutputStream(header);
            try {
                headerOut.writeInt(779316836);
                headerOut.writeInt(28);
                if (FlashAudioPlayer.player.getRendererUsed() == 2) {
                    headerOut.writeInt(this.dstSamples * loopcount);
                } else {
                    headerOut.writeInt(this.dstSamples);
                }
                headerOut.writeInt(1);
                headerOut.writeInt(8000);
                headerOut.writeInt(1);
                headerOut.writeInt(0);
            }
            catch (IOException e2) {
                System.out.println("ConvertToMulaw: IOException: return false");
                return false;
            }
            byte[] headerBytes = header.toByteArray();
            int i2 = 0;
            while (i2 < 28) {
                this.mulawData[i2] = headerBytes[i2];
                ++i2;
            }
            this.dataIsValid = true;
            return true;
        }
        return false;
    }

    void CreateMulawTable() {
        if (mulawExpTable == null) {
            mulawExpTable = new byte[256];
            int i2 = 0;
            while (i2 < 8) {
                int j2;
                int k2 = j2 = 1 << i2;
                while (j2 > 0) {
                    Sound.mulawExpTable[k2] = (byte)i2;
                    ++k2;
                    --j2;
                }
                ++i2;
            }
            Sound.mulawExpTable[0] = 0;
        }
    }

    private static byte Convert16BitToMulaw(int tempSamp) {
        int mantissa;
        byte exponent;
        int uLawByte;
        int sign;
        if (tempSamp < 0) {
            sign = 128;
            tempSamp = -tempSamp;
        } else {
            sign = 0;
        }
        int sample = tempSamp + 132;
        if (sample > Short.MAX_VALUE) {
            sample = Short.MAX_VALUE;
        }
        if ((uLawByte = ~(sign | (exponent = mulawExpTable[sample >> 7]) << 4 | (mantissa = sample >> exponent + 3 & 0xF))) == 0) {
            uLawByte = 2;
        }
        return (byte)uLawByte;
    }

    private byte[] DecompressFromADPCMAndResample() {
        int srcDelta = 0;
        int limit = 0;
        int src = 0;
        int dst = 28;
        int dstMax = this.dstSamples + 28;
        switch (this.Rate2X()) {
            case 11025: {
                srcDelta = Matrix.div(361267200, 524288000);
                break;
            }
            case 22050: {
                srcDelta = Matrix.div(722534400, 524288000);
                break;
            }
            case 44100: {
                srcDelta = Matrix.div(1445068800, 524288000);
                break;
            }
            case 88200: {
                srcDelta = Matrix.div(1445068800, 0xFA00000);
            }
        }
        this.srcDataPos = this.srcDataStart;
        byte[] tmpData = new byte[2048];
        if (tmpData == null) {
            return null;
        }
        this.Skip(0);
        byte[] dstData = new byte[this.dstSamples + 28];
        if (dstData == null) {
            return null;
        }
        int i2 = this.srcSamples;
        while (i2 > 0) {
            if (i2 > 2048) {
                this.Decompress(tmpData, 2048);
                limit = 0x8000000;
            } else {
                this.Decompress(tmpData, i2);
                limit = i2 - 1 << 16;
            }
            while (src < limit && dst < dstMax) {
                dstData[dst++] = tmpData[src >> 16];
                src += srcDelta;
            }
            if (i2 <= 2048) {
                dstData[this.dstSamples - 1] = tmpData[i2 - 1];
            } else {
                src -= 0x8000000;
            }
            i2 -= 2048;
        }
        return dstData;
    }

    private void FillBuffer() {
        while (this.bitPos <= 24) {
            this.bitBuf = this.bitBuf << 8 | 0xFF & this.srcData[this.srcDataPos++];
            this.bitPos += 8;
        }
    }

    private int GetBits(int n2) {
        if (this.bitPos < n2) {
            this.FillBuffer();
        }
        int v = this.bitBuf << 32 - this.bitPos >>> 32 - n2;
        this.bitPos -= n2;
        return v;
    }

    private int GetSBits(int n2) {
        if (this.bitPos < n2) {
            this.FillBuffer();
        }
        int v = this.bitBuf << 32 - this.bitPos >> 32 - n2;
        this.bitPos -= n2;
        return v;
    }

    private void SkipBits(int n2) {
        if (n2 <= 32) {
            while (n2 > 0) {
                int k2 = Math.min(16, n2);
                this.GetBits(k2);
                n2 -= k2;
            }
        } else {
            this.bitPos = 0;
            int k3 = (n2 -= this.bitPos) / 8;
            this.srcDataPos += k3;
            this.GetBits(n2 & 7);
        }
    }

    private void Skip(int n2) {
        int nInBlock;
        if (this.nBits == 0) {
            this.nBits = this.GetBits(2) + 2;
        }
        if ((nInBlock = this.nSamples & 0xFFFFF000) > 0 && n2 > nInBlock + this.nSamples) {
            this.nSamples += nInBlock;
            n2 -= nInBlock;
            int k2 = nInBlock * this.nBits;
            if (this.stereo) {
                k2 *= 2;
            }
            this.SkipBits(k2);
        }
        int nblocks = n2 >> 12;
        int k3 = nblocks * (22 + this.nBits * 4095);
        if (this.stereo) {
            k3 *= 2;
        }
        this.SkipBits(k3);
        n2 &= 0xFFF;
        byte[] buf = new byte[2048];
        int limit = this.stereo ? 512 : 1024;
        while (n2 > 0) {
            int k4 = Math.min(limit, n2);
            this.Decompress(buf, k4 + k4);
            n2 -= k4;
        }
    }

    private void Decompress(byte[] mulaw, int n2) {
        int dstIndex = 0;
        if (this.nBits == 0) {
            this.nBits = this.GetBits(2) + 2;
        }
        int[] indexTable = indexTables[this.nBits - 2];
        int k0 = 1 << this.nBits - 2;
        int signmask = 1 << this.nBits - 1;
        if (!this.stereo) {
            int vp = this.valpred[0];
            int ind = this.index[0];
            int ns = this.nSamples;
            while (n2-- > 0) {
                if ((++ns & 0xFFF) == 1) {
                    vp = this.GetSBits(16);
                    mulaw[dstIndex++] = Sound.Convert16BitToMulaw(vp);
                    ind = this.GetBits(6);
                    continue;
                }
                int delta = this.GetBits(this.nBits);
                int step = stepsizeTable[ind];
                int vpdiff = 0;
                int k2 = k0;
                do {
                    if ((delta & k2) != 0) {
                        vpdiff += step;
                    }
                    step >>= 1;
                } while ((k2 >>= 1) != 0);
                vp = (delta & signmask) != 0 ? (vp -= vpdiff) : (vp += (vpdiff += step));
                if ((ind += indexTable[delta & ~signmask]) < 0) {
                    ind = 0;
                } else if (ind > 88) {
                    ind = 88;
                }
                if (vp != (short)vp) {
                    vp = vp < 0 ? Short.MIN_VALUE : Short.MAX_VALUE;
                }
                mulaw[dstIndex++] = Sound.Convert16BitToMulaw(vp);
            }
            this.valpred[0] = vp;
            this.index[0] = ind;
            this.nSamples = ns;
        } else {
            int acc = 0;
            while (n2-- > 0) {
                int i2;
                ++this.nSamples;
                if ((this.nSamples & 0xFFF) == 1) {
                    i2 = 0;
                    while (i2 < 2) {
                        this.valpred[i2] = this.GetSBits(16);
                        if (i2 == 0) {
                            acc = this.valpred[i2];
                        } else {
                            acc += this.valpred[i2];
                            mulaw[dstIndex++] = Sound.Convert16BitToMulaw(acc >>= 1);
                        }
                        this.index[i2] = this.GetBits(6);
                        ++i2;
                    }
                    continue;
                }
                i2 = 0;
                while (i2 < 2) {
                    int delta = this.GetBits(this.nBits);
                    int step = stepsizeTable[this.index[i2]];
                    int vpdiff = 0;
                    int k3 = k0;
                    do {
                        if ((delta & k3) != 0) {
                            vpdiff += step;
                        }
                        step >>= 1;
                    } while ((k3 >>= 1) != 0);
                    vpdiff += step;
                    if ((delta & signmask) != 0) {
                        int n3 = i2;
                        this.valpred[n3] = this.valpred[n3] - vpdiff;
                    } else {
                        int n4 = i2;
                        this.valpred[n4] = this.valpred[n4] + vpdiff;
                    }
                    int n5 = i2;
                    this.index[n5] = this.index[n5] + indexTable[delta & ~signmask];
                    if (this.index[i2] < 0) {
                        this.index[i2] = 0;
                    } else if (this.index[i2] > 88) {
                        this.index[i2] = 88;
                    }
                    if (this.valpred[i2] != (short)this.valpred[i2]) {
                        int n6 = this.valpred[i2] = this.valpred[i2] < 0 ? Short.MIN_VALUE : Short.MAX_VALUE;
                    }
                    if (i2 == 0) {
                        acc = this.valpred[i2];
                    } else {
                        acc += this.valpred[i2];
                        mulaw[dstIndex++] = Sound.Convert16BitToMulaw(acc >>= 1);
                    }
                    ++i2;
                }
            }
        }
    }

    static {
        indexTable2 = new int[]{-1, 2};
        indexTable3 = new int[]{-1, -1, 2, 4};
        indexTable4 = new int[]{-1, -1, -1, -1, 2, 4, 6, 8};
        indexTable5 = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, 1, 2, 4, 6, 8, 10, 13, 16};
        indexTables = new int[][]{indexTable2, indexTable3, indexTable4, indexTable5};
        stepsizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
    }
}

