/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.IgnoredChars;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeDirectivesBuilder;
import graphql.language.SDLExtensionDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SourceLocation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class ScalarTypeExtensionDefinition
extends ScalarTypeDefinition
implements SDLExtensionDefinition {
    @Internal
    protected ScalarTypeExtensionDefinition(String name, List<Directive> directives, Description description, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(name, directives, description, sourceLocation, comments, ignoredChars, additionalData);
    }

    @Override
    public ScalarTypeExtensionDefinition deepCopy() {
        return new ScalarTypeExtensionDefinition(this.getName(), this.deepCopy(this.getDirectives()), this.getDescription(), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    @Override
    public String toString() {
        return "ScalarTypeExtensionDefinition{name='" + this.getName() + '\'' + ", directives=" + this.getDirectives() + '}';
    }

    public static Builder newScalarTypeExtensionDefinition() {
        return new Builder();
    }

    @Override
    public ScalarTypeExtensionDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transformExtension(builder -> builder.directives(newChildren.getChildren("directives")));
    }

    public ScalarTypeExtensionDefinition transformExtension(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeDirectivesBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private String name;
        private Description description;
        private ImmutableList<Directive> directives = ImmutableKit.emptyList();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(ScalarTypeDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.directives = ImmutableList.copyOf(existing.getDirectives());
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder directives(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            return this;
        }

        @Override
        public Builder directive(Directive directive) {
            this.directives = ImmutableKit.addToList(this.directives, directive, new Directive[0]);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public ScalarTypeExtensionDefinition build() {
            return new ScalarTypeExtensionDefinition(this.name, this.directives, this.description, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

