/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.Internal;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaTraverser;
import graphql.schema.validation.AppliedDirectiveArgumentsAreValid;
import graphql.schema.validation.AppliedDirectivesAreValid;
import graphql.schema.validation.DefaultValuesAreValid;
import graphql.schema.validation.InputAndOutputTypesUsedAppropriately;
import graphql.schema.validation.NoUnbrokenInputCycles;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.TypeAndFieldRule;
import graphql.schema.validation.TypesImplementInterfaces;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Internal
public class SchemaValidator {
    private final List<GraphQLTypeVisitor> rules = new ArrayList<GraphQLTypeVisitor>();

    public SchemaValidator() {
        this.rules.add(new NoUnbrokenInputCycles());
        this.rules.add(new TypesImplementInterfaces());
        this.rules.add(new TypeAndFieldRule());
        this.rules.add(new DefaultValuesAreValid());
        this.rules.add(new AppliedDirectivesAreValid());
        this.rules.add(new AppliedDirectiveArgumentsAreValid());
        this.rules.add(new InputAndOutputTypesUsedAppropriately());
    }

    public List<GraphQLTypeVisitor> getRules() {
        return this.rules;
    }

    public Set<SchemaValidationError> validateSchema(GraphQLSchema schema) {
        SchemaValidationErrorCollector validationErrorCollector = new SchemaValidationErrorCollector();
        LinkedHashMap rootVars = new LinkedHashMap();
        rootVars.put(GraphQLSchema.class, schema);
        rootVars.put(SchemaValidationErrorCollector.class, validationErrorCollector);
        new SchemaTraverser().depthFirstFullSchema(this.rules, schema, rootVars);
        return validationErrorCollector.getErrors();
    }
}

