/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.def;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.IResource;
import manifold.api.fs.def.JavaDirectoryImpl;
import manifold.api.fs.def.JavaFileImpl;
import manifold.api.fs.jar.JarFileDirectoryImpl;
import manifold.api.fs.url.URLFileImpl;
import manifold.api.host.IManifoldHost;
import manifold.api.service.BaseService;
import manifold.rt.api.util.ManStringUtil;

public class FileSystemImpl
extends BaseService
implements IFileSystem {
    private final IManifoldHost _host;
    private Map<File, IDirectory> _cachedDirInfo;
    private IFileSystem.CachingMode _cachingMode;
    private IDirectoryResourceExtractor _iDirectoryResourceExtractor;
    private IFileResourceExtractor _iFileResourceExtractor;
    private final ReentrantLock _lock;

    public FileSystemImpl(IManifoldHost host, IFileSystem.CachingMode cachingMode) {
        this._host = host;
        this._cachedDirInfo = new HashMap<File, IDirectory>();
        this._cachingMode = cachingMode;
        this._iDirectoryResourceExtractor = new IDirectoryResourceExtractor();
        this._iFileResourceExtractor = new IFileResourceExtractor();
        this._lock = new ReentrantLock();
    }

    @Override
    public IManifoldHost getHost() {
        return this._host;
    }

    @Override
    public IDirectory getIDirectory(File dir) {
        if (dir == null) {
            return null;
        }
        IDirectory directory = this._cachedDirInfo.get(dir = FileSystemImpl.normalizeFile(dir));
        if (directory == null) {
            this._lock.lock();
            try {
                directory = this._cachedDirInfo.get(dir);
                if (directory == null) {
                    directory = this.createDir(dir);
                    this._cachedDirInfo.put(dir, directory);
                }
            }
            finally {
                this._lock.unlock();
            }
        }
        return directory;
    }

    @Override
    public IFile getIFile(File file) {
        return file == null ? null : new JavaFileImpl(this, FileSystemImpl.normalizeFile(file));
    }

    private static File normalizeFile(File file) {
        String absolutePath = file.getAbsolutePath();
        ArrayList<String> components = new ArrayList<String>();
        boolean reallyNormalized = false;
        int lastIndex = 0;
        for (int i = 0; i < absolutePath.length(); ++i) {
            char c = absolutePath.charAt(i);
            if (c != '/' && c != '\\') continue;
            String component = absolutePath.substring(lastIndex, i);
            if (component.equals(".")) {
                reallyNormalized = true;
            } else if (component.equals("..")) {
                components.remove(components.size() - 1);
                reallyNormalized = true;
            } else {
                components.add(component);
            }
            lastIndex = i + 1;
        }
        String component = absolutePath.substring(lastIndex);
        if (component.equals(".")) {
            reallyNormalized = true;
        } else if (component.equals("..")) {
            components.remove(components.size() - 1);
            reallyNormalized = true;
        } else {
            components.add(component);
        }
        return reallyNormalized ? new File(ManStringUtil.join(components, "/")) : file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCachingMode(IFileSystem.CachingMode cachingMode) {
        this._lock.lock();
        try {
            this._cachingMode = cachingMode;
            for (IDirectory dir : this._cachedDirInfo.values()) {
                if (!(dir instanceof JavaDirectoryImpl)) continue;
                ((JavaDirectoryImpl)dir).setCachingMode(cachingMode);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    private IDirectory createDir(File dir) {
        if ((dir.getName().toLowerCase().endsWith(".jar") || dir.getName().toLowerCase().endsWith(".zip") || dir.getName().equals("bundlefile")) && dir.isFile()) {
            return new JarFileDirectoryImpl(this, dir);
        }
        return new JavaDirectoryImpl(this, dir, this._cachingMode);
    }

    @Override
    public void clearAllCaches() {
        this._lock.lock();
        try {
            for (IDirectory dir : this._cachedDirInfo.values()) {
                dir.clearCaches();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    static boolean isDirectory(File f) {
        return f.isDirectory();
    }

    @Override
    public IDirectory getIDirectory(URL url) {
        if (url == null) {
            return null;
        }
        return (IDirectory)this._iDirectoryResourceExtractor.getClassResource(url);
    }

    @Override
    public IFile getIFile(URL url) {
        if (url == null) {
            return null;
        }
        return (IFile)this._iFileResourceExtractor.getClassResource(url);
    }

    @Override
    public ReentrantLock getLock() {
        return this._lock;
    }

    private class IDirectoryResourceExtractor
    extends ResourceExtractor<IDirectory> {
        private IDirectoryResourceExtractor() {
        }

        @Override
        protected IDirectory getIResourceFromJarDirectoryAndEntryName(IDirectory jarFS, String entryName) {
            return jarFS.dir(entryName);
        }

        @Override
        protected IDirectory getIResourceFromJavaFile(URL location) {
            return FileSystemImpl.this.getHost().getFileSystem().getIDirectory(this.getFileFromURL(location));
        }

        @Override
        IDirectory getIResourceFromURL(URL location) {
            return null;
        }
    }

    private class IFileResourceExtractor
    extends ResourceExtractor<IFile> {
        private IFileResourceExtractor() {
        }

        @Override
        IFile getIResourceFromJarDirectoryAndEntryName(IDirectory jarFS, String entryName) {
            return jarFS.file(entryName);
        }

        @Override
        IFile getIResourceFromJavaFile(URL location) {
            return FileSystemImpl.this.getHost().getFileSystem().getIFile(this.getFileFromURL(location));
        }

        @Override
        IFile getIResourceFromURL(URL location) {
            return new URLFileImpl(FileSystemImpl.this, location);
        }
    }

    private abstract class ResourceExtractor<J extends IResource> {
        private ResourceExtractor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        J getClassResource(URL _url) {
            if (_url == null) {
                return null;
            }
            switch (_url.getProtocol()) {
                case "file": {
                    return this.getIResourceFromJavaFile(_url);
                }
                case "jar": {
                    URL jarFileUrl;
                    JarURLConnection urlConnection;
                    try {
                        urlConnection = (JarURLConnection)_url.openConnection();
                        jarFileUrl = urlConnection.getJarFileURL();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    File dir = new File(jarFileUrl.getFile());
                    IDirectory jarFileDirectory = (IDirectory)FileSystemImpl.this._cachedDirInfo.get(dir);
                    if (jarFileDirectory == null) {
                        FileSystemImpl.this._lock.lock();
                        try {
                            jarFileDirectory = (IDirectory)FileSystemImpl.this._cachedDirInfo.get(dir);
                            if (jarFileDirectory == null) {
                                jarFileDirectory = FileSystemImpl.this.createDir(dir);
                                FileSystemImpl.this._cachedDirInfo.put(dir, jarFileDirectory);
                            }
                        }
                        finally {
                            FileSystemImpl.this._lock.unlock();
                        }
                    }
                    return this.getIResourceFromJarDirectoryAndEntryName(jarFileDirectory, urlConnection.getEntryName());
                }
                case "http": {
                    J res = this.getIResourceFromURL(_url);
                    if (res == null) break;
                    return res;
                }
            }
            throw new RuntimeException("Unrecognized protocol: " + _url.getProtocol());
        }

        abstract J getIResourceFromURL(URL var1);

        abstract J getIResourceFromJarDirectoryAndEntryName(IDirectory var1, String var2);

        abstract J getIResourceFromJavaFile(URL var1);

        File getFileFromURL(URL url) {
            try {
                URI uri = url.toURI();
                if (uri.getFragment() != null) {
                    uri = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
                }
                return new File(uri);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unable to parse URL " + url.toExternalForm(), ex);
            }
        }
    }
}

