/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.host;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.cache.PathCache;
import manifold.api.host.Dependency;
import manifold.api.host.IManifoldHost;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;
import manifold.rt.api.util.ServiceUtil;

public interface IModule {
    public IManifoldHost getHost();

    public String getName();

    public List<IDirectory> getSourcePath();

    public List<IDirectory> getJavaClassPath();

    public List<IDirectory> getOutputPath();

    public IDirectory[] getExcludedPath();

    public List<IDirectory> getCollectiveSourcePath();

    public List<IDirectory> getCollectiveJavaClassPath();

    default public IFileSystem getFileSystem() {
        return this.getHost().getFileSystem();
    }

    public List<Dependency> getDependencies();

    public PathCache getPathCache();

    public Set<ITypeManifold> getTypeManifolds();

    public JavaFileObject produceFile(String var1, JavaFileManager.Location var2, DiagnosticListener<JavaFileObject> var3);

    default public Set<ITypeManifold> findTypeManifoldsFor(String fqn) {
        return this.findTypeManifoldsFor(fqn, null);
    }

    default public Set<ITypeManifold> findTypeManifoldsFor(String fqn, Predicate<ITypeManifold> predicate) {
        HashSet<ITypeManifold> tms = null;
        Set<ITypeManifold> typeManifolds = this.getTypeManifolds();
        for (ITypeManifold tm : typeManifolds) {
            if (predicate != null && !predicate.test(tm) || !tm.isType(fqn)) continue;
            tms = tms == null ? new HashSet<ITypeManifold>(2) : tms;
            tms.add(tm);
        }
        return tms == null ? Collections.emptySet() : tms;
    }

    default public Set<ITypeManifold> findTypeManifoldsFor(IFile file) {
        return this.findTypeManifoldsFor(file, null);
    }

    default public Set<ITypeManifold> findTypeManifoldsFor(IFile file, Predicate<ITypeManifold> predicate) {
        HashSet<ITypeManifold> tms = null;
        Set<ITypeManifold> typeManifolds = this.getTypeManifolds();
        for (ITypeManifold tm : typeManifolds) {
            if (predicate != null && !predicate.test(tm) || !tm.handlesFile(file)) continue;
            tms = tms == null ? new HashSet<ITypeManifold>(2) : tms;
            tms.add(tm);
        }
        return tms == null ? Collections.emptySet() : tms;
    }

    default public SortedSet<ITypeManifold> loadTypeManifolds() {
        TreeSet<ITypeManifold> typeManifolds = new TreeSet<ITypeManifold>(this.getTypeManifoldSorter());
        this.loadRegistered(typeManifolds);
        return typeManifolds;
    }

    default public Comparator<ITypeManifold> getTypeManifoldSorter() {
        return (tm1, tm2) -> tm1.getContributorKind() == ContributorKind.Supplemental ? 1 : -1;
    }

    default public List<String> getExcludedTypeManifolds() {
        String exclude = System.getProperty("manifold.exclude");
        if (exclude != null && !exclude.isEmpty()) {
            ArrayList<String> excluded = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(exclude, ",");
            while (tokenizer.hasMoreTokens()) {
                String excludedTypeManifold = tokenizer.nextToken().trim();
                excluded.add(excludedTypeManifold);
            }
            return excluded;
        }
        return Collections.emptyList();
    }

    default public void loadRegistered(Set<ITypeManifold> tms) {
        HashSet registeredTms = new HashSet();
        ServiceUtil.loadRegisteredServices(registeredTms, ITypeManifold.class, this.getClass().getClassLoader());
        List<String> excludedTypeManifolds = this.getExcludedTypeManifolds();
        tms.addAll(registeredTms.stream().filter(tm -> tm.accept(this) && !excludedTypeManifolds.contains(tm.getClass().getTypeName())).collect(Collectors.toSet()));
    }
}

