/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.type;

import java.util.HashSet;
import java.util.Set;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.type.IModel;

public abstract class AbstractSingleFileModel
implements IModel {
    private final IManifoldHost _host;
    private final String _fqn;
    private final Set<IFile> _files;

    public AbstractSingleFileModel(IManifoldHost host, String fqn, Set<IFile> files) {
        this._host = host;
        this._fqn = fqn;
        this._files = new HashSet<IFile>(files);
    }

    @Override
    public IManifoldHost getHost() {
        return this._host;
    }

    @Override
    public String getFqn() {
        return this._fqn;
    }

    @Override
    public Set<IFile> getFiles() {
        return this._files;
    }

    public IFile getFile() {
        return this._files.iterator().next();
    }

    @Override
    public void addFile(IFile file) {
        this._files.add(file);
    }

    @Override
    public void removeFile(IFile file) {
        this._files.remove(file);
    }

    @Override
    public void updateFile(IFile file) {
        this._files.remove(file);
        this._files.add(file);
    }
}

