/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.yaml.rt;

import manifold.api.yaml.rt.parser.YamlParser;
import manifold.rt.api.ScriptException;
import manifold.shade.org.snakeyaml.engine.v1.api.Dump;
import manifold.shade.org.snakeyaml.engine.v1.api.DumpSettings;
import manifold.shade.org.snakeyaml.engine.v1.api.DumpSettingsBuilder;
import manifold.shade.org.snakeyaml.engine.v1.api.StreamDataWriter;
import manifold.shade.org.snakeyaml.engine.v1.common.FlowStyle;
import manifold.shade.org.snakeyaml.engine.v1.exceptions.Mark;
import manifold.shade.org.snakeyaml.engine.v1.exceptions.MarkedYamlEngineException;

public class Yaml {
    public static Object fromYaml(String yaml) {
        return Yaml.fromYaml(yaml, false, false);
    }

    public static Object fromYaml(String yaml, boolean withBigNumbers, boolean withTokens) {
        try {
            return YamlParser.parseYaml(yaml, withTokens);
        }
        catch (MarkedYamlEngineException me) {
            Mark mark = me.getContextMark().isPresent() ? me.getContextMark().get() : null;
            throw new RuntimeException(new ScriptException(me.getMessage(), null, mark == null ? 0 : mark.getLine(), mark == null ? 0 : mark.getColumn()));
        }
    }

    public static void toYaml(Object jsonValue, final StringBuilder target) {
        DumpSettings settings = new DumpSettingsBuilder().setBestLineBreak("\n").setMultiLineFlow(true).setDefaultFlowStyle(FlowStyle.BLOCK).setIndent(2).build();
        new Dump(settings).dump(jsonValue, new StreamDataWriter(){

            @Override
            public void write(String str) {
                target.append(str);
            }

            @Override
            public void write(String str, int offset, int length) {
                target.append(str, offset, offset + length);
            }
        });
    }
}

