/*
 * Decompiled with CFR 0.152.
 */
package manifold.collections.extensions.java.util.List;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;

@Extension
public class ManifoldListCollectionExt {
    public static <E> E first(@This List<E> thiz) {
        if (thiz.isEmpty()) {
            throw new NoSuchElementException("List is empty.");
        }
        return thiz.get(0);
    }

    public static <E> E firstOrNull(@This List<E> thiz) {
        return thiz.isEmpty() ? null : (E)thiz.get(0);
    }

    public static <E> E last(@This List<E> thiz) {
        if (thiz.isEmpty()) {
            throw new NoSuchElementException("List is empty.");
        }
        return thiz.get(thiz.size() - 1);
    }

    public static <E> E last(@This List<E> thiz, Predicate<E> predicate) {
        ListIterator<E> iterator = thiz.listIterator(thiz.size());
        while (iterator.hasPrevious()) {
            E element = iterator.previous();
            if (!predicate.test(element)) continue;
            return element;
        }
        throw new NoSuchElementException("List contains no element matching the predicate.");
    }

    public static <E> E lastOrNull(@This List<E> thiz) {
        return thiz.isEmpty() ? null : (E)thiz.get(thiz.size() - 1);
    }

    public static <E> E lastOrNull(@This List<E> thiz, Predicate<E> predicate) {
        ListIterator<E> iterator = thiz.listIterator(thiz.size());
        while (iterator.hasPrevious()) {
            E element = iterator.previous();
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }

    public static <E> E single(@This List<E> thiz) {
        switch (thiz.size()) {
            case 0: {
                throw new NoSuchElementException("List is empty.");
            }
            case 1: {
                return thiz.get(0);
            }
        }
        throw new IllegalArgumentException("List has more than one element.");
    }

    public static <E> E singleOrNull(@This List<E> thiz) {
        return thiz.size() == 1 ? (E)thiz.get(0) : null;
    }

    public static <E> E getOrNull(@This List<E> thiz, int index) {
        return index >= 0 && index < thiz.size() ? (E)thiz.get(index) : null;
    }

    public static <E> void reverse(@This List<E> thiz) {
        Collections.reverse(thiz);
    }

    public static <E> List<E> optimizeReadOnlyList(@This List<E> thiz) {
        switch (thiz.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(thiz.get(0));
            }
        }
        return Collections.unmodifiableList(thiz);
    }
}

