/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import manifold.internal.javac.IDynamicJdk;
import manifold.rt.api.util.TypesUtil;

public interface ManTypes {
    public static final ThreadLocal<Map<Pair<Type, Type>, Boolean>> CACHED_PAIRS = ThreadLocal.withInitial(HashMap::new);

    public Types types();

    default public boolean isAssignableToStructuralType(Type t, Type s) {
        try {
            return this._isAssignableToStructuralType(t, s);
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean _isAssignableToStructuralType(Type t, Type s) {
        Pair<Type, Type> pair;
        t = this.types().erasure(t);
        s = this.types().erasure(s);
        if (!(t instanceof Type.ClassType)) {
            return false;
        }
        if (!TypesUtil.isStructuralInterface(this.types(), s.tsym)) {
            return false;
        }
        Map<Pair<Type, Type>, Boolean> cache = CACHED_PAIRS.get();
        if (cache.containsKey(pair = new Pair<Type, Type>(t, s))) {
            Boolean result = cache.get(pair);
            return result == null || result != false;
        }
        cache.put(pair, null);
        try {
            HashSet<Symbol.MethodSymbol> sMethods = new HashSet<Symbol.MethodSymbol>();
            ManTypes.getAllMethods(s, m -> !m.isStatic() && (m.flags() & 0x80000000000L) == 0L && (m.flags() & 1L) != 0L && (m.flags() & 0x1000L) == 0L, sMethods);
            HashSet<Symbol.MethodSymbol> tMethods = new HashSet<Symbol.MethodSymbol>();
            ManTypes.getAllMethods(t, m -> !m.isStatic() && (m.flags() & 1L) != 0L, tMethods);
            boolean result = sMethods.stream().allMatch(m -> tMethods.stream().anyMatch(tm -> m.flatName().equals(tm.flatName()) && this.types().isAssignable(this.types().erasure(tm.getReturnType()), this.types().erasure(m.getReturnType())) && this.hasStructurallyEquivalentArgs((Symbol.MethodSymbol)tm, (Symbol.MethodSymbol)m)));
            cache.put(pair, result);
            boolean bl = result;
            return bl;
        }
        finally {
            cache.remove(pair);
        }
    }

    public static void getAllMethods(Type t, Predicate<Symbol.MethodSymbol> filter, Set<Symbol.MethodSymbol> tMethods) {
        if (!(t instanceof Type.ClassType)) {
            return;
        }
        Symbol.ClassSymbol tsym = (Symbol.ClassSymbol)t.tsym;
        for (Symbol sym : IDynamicJdk.instance().getMembers(tsym, m -> m instanceof Symbol.MethodSymbol && filter.test((Symbol.MethodSymbol)m))) {
            tMethods.add((Symbol.MethodSymbol)sym);
        }
        ManTypes.getAllMethods(tsym.getSuperclass(), filter, tMethods);
        for (Type iface : tsym.getInterfaces()) {
            ManTypes.getAllMethods(iface, filter, tMethods);
        }
    }

    default public boolean hasStructurallyEquivalentArgs(Symbol.MethodSymbol t, Symbol.MethodSymbol s) {
        java.util.List tParams = t.getParameters();
        java.util.List sParams = s.getParameters();
        if (((List)tParams).size() != ((List)sParams).size()) {
            return false;
        }
        for (int i = 0; i < ((List)sParams).size(); ++i) {
            Symbol.VarSymbol sParam = (Symbol.VarSymbol)((List)sParams).get(i);
            Symbol.VarSymbol tParam = (Symbol.VarSymbol)((List)tParams).get(i);
            if (this.types().isAssignable(sParam.type, tParam.type)) continue;
            return false;
        }
        return true;
    }
}

