/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.host.IManifoldHost;
import manifold.api.host.IModule;
import manifold.api.host.ITypeSystemListener;
import manifold.api.host.RefreshRequest;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;
import manifold.api.type.TypeName;
import manifold.api.util.cache.FqnCache;
import manifold.api.util.cache.FqnCacheNode;
import manifold.internal.host.SimpleModule;
import manifold.internal.javac.GeneratedJavaStubFileObject;
import manifold.internal.javac.InMemoryClassJavaFileObject;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.JavacFileManagerBridge;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManPatchLocation;
import manifold.internal.javac.ManPatchModuleLocation;
import manifold.internal.javac.MissFileObject;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.Stack;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

class ManifoldJavaFileManager
extends JavacFileManagerBridge<JavaFileManager>
implements ITypeSystemListener {
    private static final JavaFileObject MISS_FO = new MissFileObject();
    static final Context.Key<Stack> MODULE_CTX = new Context.Key<Stack>(){};
    private final IManifoldHost _host;
    private final boolean _fromJavaC;
    private FqnCache<InMemoryClassJavaFileObject> _classFiles;
    private FqnCache<JavaFileObject> _generatedFiles;
    private Context _ctx;
    private int _runtimeMode;

    ManifoldJavaFileManager(IManifoldHost host, JavaFileManager fileManager, Context ctx, boolean fromJavaC) {
        super(fileManager, ctx == null ? (ctx = new Context()) : ctx);
        this._host = host;
        this._ctx = ctx;
        this._fromJavaC = fromJavaC;
        this._classFiles = new FqnCache();
        this._generatedFiles = new FqnCache();
        if (JreUtil.isJava9orLater()) {
            ctx.put(MODULE_CTX, new Stack());
        }
        if (ctx.get(JavaFileManager.class) == null) {
            ctx.put(JavaFileManager.class, fileManager);
        }
        this._host.addTypeSystemListenerAsWeakRef(null, this);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this._ctx = context;
    }

    public IManifoldHost getHost() {
        return this._host;
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) {
        String name;
        if (location instanceof ManPatchLocation && (name = ((ManPatchLocation)location).inferModuleName(this._ctx)) != null) {
            return name;
        }
        return super.inferModuleName(location);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return !JreUtil.isJava8() && location == ReflectUtil.field(StandardLocation.class, "PATCH_MODULE_PATH").getStatic() || super.hasLocation(location);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        JavaFileManager.Location locationForModule = super.getLocationForModule(location, moduleName);
        if (location == ReflectUtil.field(StandardLocation.class, "PATCH_MODULE_PATH").getStatic()) {
            return new ManPatchModuleLocation(moduleName, locationForModule);
        }
        return locationForModule;
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        if (fo instanceof GeneratedJavaStubFileObject && location == ReflectUtil.field(StandardLocation.class, "PATCH_MODULE_PATH").getStatic()) {
            return new ManPatchLocation((GeneratedJavaStubFileObject)fo);
        }
        return super.getLocationForModule(location, fo);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (!this.okToWriteClassFile(kind, sibling)) {
            InMemoryClassJavaFileObject file = new InMemoryClassJavaFileObject(className, kind);
            if (!(sibling instanceof GeneratedJavaStubFileObject) || ((GeneratedJavaStubFileObject)sibling).isPrimary()) {
                this._classFiles.add(className, file);
                className = className.replace('$', '.');
                this._classFiles.add(className, file);
            }
            return file;
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    private boolean okToWriteClassFile(JavaFileObject.Kind kind, FileObject fo) {
        return !this.isRuntimeMode() && this._fromJavaC && !this.isIntellijPluginTemporaryFile(kind, fo) && (kind != JavaFileObject.Kind.CLASS || !(fo instanceof GeneratedJavaStubFileObject) || JavacPlugin.instance().isStaticCompile() && (((GeneratedJavaStubFileObject)fo).isPrimary() || fo.getName().contains("generatedproxy_")));
    }

    private boolean isIntellijPluginTemporaryFile(JavaFileObject.Kind kind, FileObject fo) {
        String name = fo == null ? null : fo.getName();
        return name != null && name.contains("_Manifold_Temp_Main_");
    }

    public InMemoryClassJavaFileObject findCompiledFile(String fqn) {
        return this._classFiles.get(fqn);
    }

    public JavaFileObject getSourceFileForInput(JavaFileManager.Location location, String fqn, JavaFileObject.Kind kind, DiagnosticListener<JavaFileObject> errorHandler) {
        try {
            JavaFileObject file = super.getJavaFileForInput(location, fqn, kind);
            if (file != null) {
                return file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.findGeneratedFile(fqn.replace('$', '.'), location, this.getHost().getSingleModule(), errorHandler);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> list = super.list(location instanceof ManPatchModuleLocation ? ((ManPatchModuleLocation)location).getLocationForModule() : location, packageName, new HashSet<JavaFileObject.Kind>(kinds), recurse);
        if (kinds.contains((Object)JavaFileObject.Kind.SOURCE) && (location == StandardLocation.SOURCE_PATH || location == StandardLocation.CLASS_PATH || location instanceof ManPatchModuleLocation)) {
            Set<TypeName> children;
            SimpleModule compilingModule = (SimpleModule)this.getHost().getSingleModule();
            Set<TypeName> set2 = children = compilingModule == null ? null : compilingModule.getChildrenOfNamespace(packageName);
            if (children == null || children.isEmpty()) {
                return list;
            }
            ArrayList<JavaFileObject> newList = new ArrayList<JavaFileObject>();
            list.forEach(newList::add);
            Set<String> names = this.makeNames(list);
            Iterable<JavaFileObject> patchableFiles = null;
            if (location instanceof ManPatchModuleLocation) {
                HashSet<JavaFileObject.Kind> classesAndSource = new HashSet<JavaFileObject.Kind>(Arrays.asList(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE));
                JavaFileManager.Location modulePatchLocation = this.makeModuleLocation((ManPatchModuleLocation)location);
                if (modulePatchLocation == null) {
                    return list;
                }
                patchableFiles = super.list(modulePatchLocation, packageName, classesAndSource, recurse);
            }
            for (TypeName tn : children) {
                if (names.contains(ManClassUtil.getShortClassName(tn.name))) continue;
                if (tn.kind == TypeName.Kind.NAMESPACE) {
                    if (!recurse) continue;
                    Iterable<JavaFileObject> sublist = this.list(location, tn.name, kinds, recurse);
                    sublist.forEach(newList::add);
                    continue;
                }
                IssueReporter<JavaFileObject> issueReporter = new IssueReporter<JavaFileObject>(() -> this._ctx);
                String fqn = tn.name.replace('$', '.');
                JavaFileObject file = this.findGeneratedFile(fqn, location, tn.getModule(), issueReporter);
                if (file == null || !this.isSourceOk(file, location) || !this.isCorrectModule(tn.getModule(), location, patchableFiles, file, fqn)) continue;
                newList.add(file);
            }
            list = newList;
        }
        return list;
    }

    private boolean isSourceOk(JavaFileObject file, JavaFileManager.Location location) {
        JavacPlugin javacPlugin = JavacPlugin.instance();
        boolean isModular = javacPlugin != null && JreUtil.isJava9Modular_compiler(javacPlugin.getContext());
        return location != StandardLocation.CLASS_PATH || !isModular || file instanceof GeneratedJavaStubFileObject && !((GeneratedJavaStubFileObject)file).isPrimary();
    }

    private boolean isCorrectModule(IModule module, JavaFileManager.Location location, Iterable<JavaFileObject> patchableFiles, JavaFileObject file, String fqn) {
        if (!(location instanceof ManPatchModuleLocation)) {
            if (!JreUtil.isJava9Modular_compiler(this._ctx)) {
                return true;
            }
            Set<ITypeManifold> typeManifoldsFor = this.getHost().getSingleModule().findTypeManifoldsFor(fqn, tm -> tm.getContributorKind() == ContributorKind.Primary);
            if (typeManifoldsFor.isEmpty() && fqn.contains(".generatedproxy_")) {
                typeManifoldsFor = this.getHost().getSingleModule().findTypeManifoldsFor(fqn, tm -> tm.getContributorKind() == ContributorKind.Supplemental);
            }
            return !typeManifoldsFor.isEmpty();
        }
        Set<ITypeManifold> tms = module.findTypeManifoldsFor(fqn);
        if (tms.stream().anyMatch(tm -> tm.getContributorKind() == ContributorKind.Primary)) {
            return true;
        }
        if (patchableFiles == null) {
            return true;
        }
        String cname = this.inferBinaryName(location, file);
        for (JavaFileObject f : patchableFiles) {
            String name = this.inferBinaryName(location, f);
            if (!cname.equals(name)) continue;
            return true;
        }
        return false;
    }

    private JavaFileManager.Location makeModuleLocation(ManPatchModuleLocation location) {
        Symbol moduleElement = (Symbol)ReflectUtil.method(Symtab.instance(this._ctx), "getModule", Name.class).invoke(Names.instance(this._ctx).fromString(location.getName()));
        if (moduleElement == null) {
            return null;
        }
        return (JavaFileManager.Location)ReflectUtil.field(moduleElement, "classLocation").get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFileObject findGeneratedFile(String fqn, JavaFileManager.Location location, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        JavaFileObject fo;
        FqnCacheNode<JavaFileObject> node = this._generatedFiles.getNode(fqn);
        if (node != null && (fo = node.getUserData()) != null) {
            return fo == MISS_FO ? null : fo;
        }
        if (this.isFilteredFromIncrementalCompilation(fqn)) {
            return null;
        }
        this.pushLocation(location);
        try {
            fo = module.produceFile(fqn, location, errorHandler);
        }
        finally {
            this.popLocation(location);
        }
        this._generatedFiles.add(fqn, fo == null ? MISS_FO : fo);
        return fo;
    }

    private void pushLocation(JavaFileManager.Location location) {
        if (JavacPlugin.instance() == null || !JreUtil.isJava9orLater()) {
            return;
        }
        if (location == null) {
            throw new IllegalStateException("null Location");
        }
        Object module = this.inferModule(location);
        this._ctx.get(MODULE_CTX).push(module);
    }

    private void popLocation(JavaFileManager.Location location) {
        if (JavacPlugin.instance() == null || !JreUtil.isJava9orLater()) {
            return;
        }
        Object top = this._ctx.get(MODULE_CTX).pop();
        if (top != this.inferModule(location)) {
            throw new IllegalStateException("stack not balanced");
        }
    }

    private Object inferModule(JavaFileManager.Location location) {
        String moduleName;
        Object modules = ReflectUtil.method("com.sun.tools.javac.comp.Modules", "instance", Context.class).invokeStatic(this._ctx);
        Object defaultModule = ReflectUtil.method(modules, "getDefaultModule", new Class[0]).invoke(new Object[0]);
        if (defaultModule == ReflectUtil.field(Symtab.instance(this._ctx), "noModule").get()) {
            return defaultModule;
        }
        Set rootModules = (Set)ReflectUtil.method(modules, "getRootModules", new Class[0]).invoke(new Object[0]);
        Object moduleSym = null;
        if (location instanceof ManPatchLocation && (moduleName = ((ManPatchLocation)location).inferModuleName(this._ctx)) != null) {
            Name name = Names.instance(this._ctx).fromString(moduleName);
            moduleSym = ReflectUtil.method(modules, "getObservableModule", Name.class).invoke(name);
            if (moduleSym == null) {
                throw new IllegalStateException("null module symbol for module: '" + moduleName + "'");
            }
        }
        if (rootModules.size() == 1) {
            return rootModules.iterator().next();
        }
        throw new IllegalStateException("no module inferred");
    }

    private boolean isFilteredFromIncrementalCompilation(String fqn) {
        JavacPlugin javacPlugin = JavacPlugin.instance();
        if (javacPlugin == null || !javacPlugin.isIncremental()) {
            return false;
        }
        List<File> changedFiles = ManifoldJavaFileManager.getChangedResourceFiles();
        IManifoldHost host = this.getHost();
        Set changes = changedFiles.stream().map(f -> host.getFileSystem().getIFile((File)f)).collect(Collectors.toSet());
        for (ITypeManifold tm : host.getSingleModule().getTypeManifolds()) {
            if ((tm.getContributorKind() == ContributorKind.Supplemental || !tm.isFileBacked()) && tm.isType(fqn)) {
                return false;
            }
            for (IFile file : tm.findFilesForType(fqn)) {
                if (!(file instanceof IFileFragment)) continue;
                return false;
            }
            for (IFile file : changes) {
                Set types = Arrays.stream(tm.getTypesForFile(file)).collect(Collectors.toSet());
                if (!types.contains(fqn)) continue;
                return false;
            }
        }
        return true;
    }

    public static List<File> getChangedResourceFiles() {
        List changedFiles = Collections.emptyList();
        Class<?> type = ReflectUtil.type("manifold.ij.jps.IjChangedResourceFiles");
        if (type != null) {
            changedFiles = (List)ReflectUtil.method(type, "getChangedFiles", new Class[0]).invokeStatic(new Object[0]);
        }
        return changedFiles;
    }

    private Set<String> makeNames(Iterable<JavaFileObject> list) {
        HashSet<String> set2 = new HashSet<String>();
        for (JavaFileObject file : list) {
            String name = file.getName();
            if (!name.endsWith(".java")) continue;
            set2.add(name.substring(name.lastIndexOf(File.separatorChar) + 1, name.lastIndexOf(46)));
        }
        return set2;
    }

    public void remove(String fqn) {
        this._classFiles.remove(fqn);
    }

    @Override
    public void refreshedTypes(RefreshRequest request) {
        switch (request.kind) {
            case CREATION: 
            case MODIFICATION: 
            case DELETION: {
                this._classFiles.remove(request.types);
                this._generatedFiles.remove(request.types);
            }
        }
    }

    @Override
    public void refreshed() {
        this._classFiles = new FqnCache();
    }

    public Collection<InMemoryClassJavaFileObject> getCompiledFiles() {
        HashSet<InMemoryClassJavaFileObject> files = new HashSet<InMemoryClassJavaFileObject>();
        this._classFiles.visitDepthFirst(o -> {
            if (o != null) {
                files.add((InMemoryClassJavaFileObject)o);
            }
            return true;
        });
        return files;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject fileObj) {
        if (fileObj instanceof GeneratedJavaStubFileObject) {
            return ManifoldJavaFileManager.removeExtension(fileObj.getName()).replace(File.separatorChar, '.').replace('/', '.');
        }
        if (fileObj instanceof SourceJavaFileObject) {
            return ((SourceJavaFileObject)fileObj).inferBinaryName(location);
        }
        if (location instanceof ManPatchModuleLocation) {
            if (fileObj.getClass().getSimpleName().equals("DirectoryFileObject")) {
                RelativePath relativePath = (RelativePath)ReflectUtil.field(fileObj, "relativePath").get();
                return ManifoldJavaFileManager.removeExtension(relativePath.getPath()).replace(File.separatorChar, '.').replace('/', '.');
            }
            if (fileObj.getClass().getSimpleName().equals("SigJavaFileObject")) {
                FileObject fileObject = (FileObject)ReflectUtil.field(fileObj, "fileObject").get();
                return fileObject instanceof JavaFileObject ? this.inferBinaryName(location, (JavaFileObject)fileObject) : null;
            }
            if (fileObj.getClass().getSimpleName().equals("JarFileObject")) {
                String relativePath = ReflectUtil.method(fileObj, "getPath", new Class[0]).invoke(new Object[0]).toString();
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                return ManifoldJavaFileManager.removeExtension(relativePath).replace(File.separatorChar, '.').replace('/', '.');
            }
        }
        return super.inferBinaryName(location, fileObj);
    }

    @Override
    public boolean isSameFile(FileObject file1, FileObject file2) {
        if (file1 instanceof GeneratedJavaStubFileObject || file2 instanceof GeneratedJavaStubFileObject) {
            return file1.equals(file2);
        }
        return super.isSameFile(file1, file2);
    }

    private static String removeExtension(String fileName) {
        int iDot = fileName.lastIndexOf(".");
        return iDot == -1 ? fileName : fileName.substring(0, iDot);
    }

    public int pushRuntimeMode() {
        return this._runtimeMode++;
    }

    public void popRuntimeMode(int check) {
        if (--this._runtimeMode != check) {
            throw new IllegalStateException("runtime mode unbalanced");
        }
    }

    public boolean isRuntimeMode() {
        return this._runtimeMode > 0;
    }
}

