/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import manifold.rt.api.util.PathUtil;
import manifold.rt.api.util.StreamUtil;

public class SourceJavaFileObject
extends SimpleJavaFileObject {
    private CharSequence _content;
    private String _fqn;

    public SourceJavaFileObject(URI uri) {
        this(uri, true);
    }

    public SourceJavaFileObject(URI uri, boolean preload) {
        super(uri, JavaFileObject.Kind.SOURCE);
        if (preload) {
            try {
                this._content = this.getCharContent(true);
            }
            catch (IOException ignore) {
                this._content = "";
            }
        }
    }

    public SourceJavaFileObject(String filename) {
        super(PathUtil.create(filename, new String[0]).toUri(), JavaFileObject.Kind.SOURCE);
    }

    public String getFqn() {
        return this._fqn;
    }

    public void setFqn(String fqn) {
        this._fqn = fqn;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        if (this._content != null) {
            return this._content;
        }
        Path file = PathUtil.create(this.uri);
        try (BufferedReader reader = PathUtil.createReader(file);){
            this._content = StreamUtil.getContent(reader);
            String string = this._content;
            return string;
        }
    }

    public String inferBinaryName(JavaFileManager.Location location) {
        if (this._fqn == null) {
            throw new IllegalStateException("Null class name");
        }
        return this._fqn;
    }
}

