/*
 * Decompiled with CFR 0.152.
 */
package manifold.rt.api.util;

import com.sun.tools.javac.api.JavacTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Stream;

public class PathUtil {
    public static boolean mkdirs(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean mkdir(Path copy, FileAttribute ... attrs) {
        try {
            return Files.createDirectory(copy, attrs) != null;
        }
        catch (FileAlreadyExistsException faee) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getName(Path path) {
        return path.getFileName().toString();
    }

    public static boolean isFile(Path path, LinkOption ... options) {
        return Files.isRegularFile(path, options);
    }

    public static boolean isDirectory(Path fileOrDir, LinkOption ... options) {
        return Files.isDirectory(fileOrDir, options);
    }

    public static Path create(String first, String ... more) {
        Path path = Paths.get(first, more);
        if (!path.isAbsolute()) {
            path = PathUtil.resolveRelativePath(first, more);
        }
        return path;
    }

    public static Path create(Path root, String createMe) {
        if (!root.isAbsolute()) {
            return PathUtil.resolveRelativePath(root.toString(), createMe);
        }
        return root.resolve(createMe);
    }

    public static Path create(URI uri) {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException nfe) {
            try {
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "true");
                FileSystem fs = FileSystems.newFileSystem(uri, env);
                return fs.provider().getPath(uri);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String findToolsJar() {
        String javaHome = System.getProperty("java.home");
        String toolsJar = javaHome + File.separator + "lib" + File.separator + "tools.jar";
        if (!PathUtil.isFile(PathUtil.create(toolsJar, new String[0]), new LinkOption[0])) {
            try {
                URI toolsJarUri = JavacTool.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                toolsJar = new File(toolsJarUri).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                System.out.println("Could not find tools.jar");
            }
        }
        return toolsJar;
    }

    private static Path resolveRelativePath(String first, String ... more) {
        String workingDirName = System.getProperty("user.dir");
        if (workingDirName == null) {
            throw new IllegalStateException("Working directory yet defined");
        }
        Path workingDir = Paths.get(workingDirName, new String[0]);
        Path path = workingDir.resolve(first);
        if (more != null) {
            for (String part2 : more) {
                path = path.resolve(part2);
            }
        }
        return path;
    }

    public static String getAbsolutePathName(Path path) {
        return path.toAbsolutePath().toString();
    }

    public static String getAbsolutePathName(String path) {
        return PathUtil.create(path, new String[0]).toAbsolutePath().toString();
    }

    public static Path getAbsolutePath(Path path) {
        return path.toAbsolutePath();
    }

    public static Path getAbsolutePath(String path) {
        return PathUtil.create(path, new String[0]).toAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path[] listFiles(Path path) {
        try (Stream<Path> list = Files.list(path);){
            Path[] pathArray = (Path[])list.toArray(Path[]::new);
            return pathArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean createNewFile(Path file, FileAttribute ... attrs) {
        try {
            return Files.createFile(file, attrs) != null;
        }
        catch (FileAlreadyExistsException faee) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedReader createReader(Path file) {
        try {
            return Files.newBufferedReader(file, Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedWriter createWriter(Path path) {
        try {
            return Files.newBufferedWriter(path, Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OutputStream createOutputStream(Path path, OpenOption ... options) {
        try {
            return Files.newOutputStream(path, options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream createInputStream(Path path, OpenOption ... options) {
        try {
            return Files.newInputStream(path, options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void delete(Path path) {
        PathUtil.delete(path, false);
    }

    public static void delete(Path path, boolean bRecursive) {
        if (bRecursive && PathUtil.isDirectory(path, new LinkOption[0])) {
            for (Path child : PathUtil.listFiles(path)) {
                PathUtil.delete(child, bRecursive);
            }
        }
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exists(Path path, LinkOption ... options) {
        return Files.exists(path, options);
    }

    public static long lastModified(Path path, LinkOption ... options) {
        try {
            return Files.getLastModifiedTime(path, options).toMillis();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean renameTo(Path from, Path to, CopyOption ... options) {
        try {
            return Files.move(from, to, options) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean canWrite(Path path) {
        if (!PathUtil.isFile(path, new LinkOption[0])) {
            return false;
        }
        try {
            return path.toFile().canWrite();
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public static boolean setWritable(Path file, boolean bWritable) {
        try {
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(file, new LinkOption[0]);
            if (bWritable) {
                perms.add(PosixFilePermission.OWNER_WRITE);
            } else {
                perms.remove((Object)PosixFilePermission.OWNER_WRITE);
            }
            return Files.setPosixFilePermissions(file, perms) != null;
        }
        catch (UnsupportedOperationException uoe) {
            try {
                return file.toFile().setWritable(bWritable);
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

