/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.extensions.java.time.LocalDateTime;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import manifold.ext.rt.api.ComparableUsing;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.util.Rational;

@Extension
public class ManLocalDateTimeExt {
    public static LocalDateTime plus(@This LocalDateTime thiz, Time time) {
        if (((TimeUnit)time.getDisplayUnit()).isDateBased()) {
            Rational rational;
            Rational years = time.toBaseNumber().div(TimeUnit.Year.getSeconds());
            int wholeYears = years.wholePart().intValue();
            Rational months = years.fractionPart().times(TimeUnit.Year.getSeconds()).div(TimeUnit.Month.getSeconds());
            int wholeMonths = months.wholePart().intValue();
            Rational days = months.fractionPart().times(TimeUnit.Month.getSeconds()).div(TimeUnit.Day.getSeconds());
            int wholeDays = days.wholePart().intValue();
            Period period = Period.of(wholeYears, wholeMonths, wholeDays);
            LocalDateTime newDate = thiz.plus(period);
            Rational seconds = days.fractionPart().times(TimeUnit.Day.getSeconds());
            if (seconds == (rational = Rational.ZERO) ? false : (seconds == null || rational == null ? true : seconds.compareToUsing(rational, ComparableUsing.Operator.NE))) {
                long wholeSeconds = seconds.wholePart().longValue();
                long nanos = seconds.fractionPart().times(1.0E9).longValue();
                newDate = newDate.plus(Duration.ofSeconds(wholeSeconds, nanos));
            }
            return newDate;
        }
        return thiz.plus(time);
    }

    public static LocalDateTime minus(@This LocalDateTime thiz, Time time) {
        if (((TimeUnit)time.getDisplayUnit()).isDateBased()) {
            Rational rational;
            Rational years = time.toBaseNumber().div(TimeUnit.Year.getSeconds());
            int wholeYears = years.wholePart().intValue();
            Rational months = years.fractionPart().times(TimeUnit.Year.getSeconds()).div(TimeUnit.Month.getSeconds());
            int wholeMonths = months.wholePart().intValue();
            Rational days = months.fractionPart().times(TimeUnit.Month.getSeconds()).div(TimeUnit.Day.getSeconds());
            int wholeDays = days.wholePart().intValue();
            Period period = Period.of(wholeYears, wholeMonths, wholeDays);
            LocalDateTime newDate = thiz.minus(period);
            Rational seconds = days.fractionPart().times(TimeUnit.Day.getSeconds());
            if (seconds == (rational = Rational.ZERO) ? false : (seconds == null || rational == null ? true : seconds.compareToUsing(rational, ComparableUsing.Operator.NE))) {
                long wholeSeconds = seconds.wholePart().longValue();
                long nanos = seconds.fractionPart().times(1.0E9).longValue();
                newDate = newDate.minus(Duration.ofSeconds(wholeSeconds, nanos));
            }
            return newDate;
        }
        return thiz.minus(time);
    }
}

