/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.ext.rt.api.ComparableUsing;
import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.Acceleration;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.MassUnit;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class AccelerationUnit
extends AbstractQuotientUnit<VelocityUnit, TimeUnit, Acceleration, AccelerationUnit> {
    private static final UnitCache<AccelerationUnit> CACHE = new UnitCache();
    public static final AccelerationUnit BASE = AccelerationUnit.get(VelocityUnit.BASE, VelocityUnit.BASE.getTimeUnit());
    public static final AccelerationUnit GRAVITY = AccelerationUnit.get(VelocityUnit.BASE, VelocityUnit.BASE.getTimeUnit(), CoercionConstants.r.postfixBind("9.80665"), "Gravity", "g");

    public static AccelerationUnit get(VelocityUnit velocityUnit, TimeUnit timeUnit) {
        return AccelerationUnit.get(velocityUnit, timeUnit, null, null, null);
    }

    public static AccelerationUnit get(VelocityUnit velocityUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        AccelerationUnit unit = new AccelerationUnit(velocityUnit, timeUnit, factor, name, symbol);
        return (AccelerationUnit)CACHE.get(unit);
    }

    private AccelerationUnit(VelocityUnit velocityUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        super(velocityUnit, timeUnit, factor, name, symbol);
    }

    @Override
    public Acceleration makeDimension(Number amount) {
        return new Acceleration(Rational.get(amount), this);
    }

    @Override
    public String getFullName() {
        TimeUnit timeUnit;
        TimeUnit timeUnit2 = this.getVelocityUnit().getTimeUnit();
        return (timeUnit2 == (timeUnit = this.getTimeUnit()) ? true : (timeUnit2 == null || timeUnit == null ? false : timeUnit2.compareToUsing(timeUnit, ComparableUsing.Operator.EQ))) ? this.getVelocityUnit().getLengthUnit().getFullName() + "/" + this.getTimeUnit().getFullName() + "\u00b2" : this.getVelocityUnit().getFullName() + "/" + this.getTimeUnit().getFullName();
    }

    @Override
    public String getFullSymbol() {
        TimeUnit timeUnit;
        TimeUnit timeUnit2 = this.getVelocityUnit().getTimeUnit();
        return (timeUnit2 == (timeUnit = this.getTimeUnit()) ? true : (timeUnit2 == null || timeUnit == null ? false : timeUnit2.compareToUsing(timeUnit, ComparableUsing.Operator.EQ))) ? this.getVelocityUnit().getLengthUnit().getFullSymbol() + "/" + this.getTimeUnit().getFullSymbol() + "\u00b2" : this.getVelocityUnit().getFullSymbol() + "/" + this.getTimeUnit().getFullSymbol();
    }

    public VelocityUnit getVelocityUnit() {
        return (VelocityUnit)this.getLeftUnit();
    }

    public TimeUnit getTimeUnit() {
        return (TimeUnit)this.getRightUnit();
    }

    public ForceUnit postfixBind(MassUnit mass) {
        return this.times(mass);
    }

    @Override
    public ForceUnit times(MassUnit t) {
        return ForceUnit.get(t, this);
    }
}

