/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.Density;
import manifold.science.measures.MassUnit;
import manifold.science.measures.VolumeUnit;
import manifold.science.util.Rational;

public final class DensityUnit
extends AbstractQuotientUnit<MassUnit, VolumeUnit, Density, DensityUnit> {
    private static final UnitCache<DensityUnit> CACHE = new UnitCache();
    public static final DensityUnit BASE = DensityUnit.get(MassUnit.Kilogram, VolumeUnit.BASE);

    public static DensityUnit get(MassUnit massUnit, VolumeUnit volumeUnit) {
        return DensityUnit.get(massUnit, volumeUnit, null, null, null);
    }

    public static DensityUnit get(MassUnit massUnit, VolumeUnit volumeUnit, Rational factor, String name, String symbol) {
        DensityUnit unit = new DensityUnit(massUnit, volumeUnit, factor, name, symbol);
        return (DensityUnit)CACHE.get(unit);
    }

    private DensityUnit(MassUnit massUnit, VolumeUnit volumeUnit, Rational factor, String name, String symbol) {
        super(massUnit, volumeUnit, factor, name, symbol);
    }

    @Override
    public Density makeDimension(Number amount) {
        return new Density(Rational.get(amount), this);
    }

    public MassUnit getMassUnit() {
        return (MassUnit)this.getLeftUnit();
    }

    public VolumeUnit getVolumeUnit() {
        return (VolumeUnit)this.getRightUnit();
    }
}

