/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.Potential;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.ResistanceUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class PotentialUnit
extends AbstractQuotientUnit<PowerUnit, CurrentUnit, Potential, PotentialUnit> {
    private static final UnitCache<PotentialUnit> CACHE = new UnitCache();
    public static final PotentialUnit V;
    public static final PotentialUnit BASE;

    public static PotentialUnit get(PowerUnit powerUnit, CurrentUnit currentUnit) {
        return PotentialUnit.get(powerUnit, currentUnit, null, null, null);
    }

    public static PotentialUnit get(PowerUnit powerUnit, CurrentUnit currentUnit, Rational factor, String name, String symbol) {
        PotentialUnit unit = new PotentialUnit(powerUnit, currentUnit, factor, name, symbol);
        return (PotentialUnit)CACHE.get(unit);
    }

    private PotentialUnit(PowerUnit powerUnit, CurrentUnit currentUnit, Rational factor, String name, String symbol) {
        super(powerUnit, currentUnit, factor, name, symbol);
    }

    @Override
    public Potential makeDimension(Number amount) {
        return new Potential(Rational.get(amount), this);
    }

    public PowerUnit getPowerUnit() {
        return (PowerUnit)this.getLeftUnit();
    }

    public CurrentUnit getCurrentUnit() {
        return (CurrentUnit)this.getRightUnit();
    }

    public ResistanceUnit div(CurrentUnit current) {
        return ResistanceUnit.get(this, current);
    }

    static {
        BASE = V = PotentialUnit.get(PowerUnit.BASE, CurrentUnit.BASE, CoercionConstants.r.postfixBind(1), "Volt", "V");
    }
}

