/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.InductanceUnit;
import manifold.science.measures.PotentialUnit;
import manifold.science.measures.Resistance;
import manifold.science.measures.TimeUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class ResistanceUnit
extends AbstractQuotientUnit<PotentialUnit, CurrentUnit, Resistance, ResistanceUnit> {
    private static final UnitCache<ResistanceUnit> CACHE = new UnitCache();
    public static final ResistanceUnit ohm;
    public static final ResistanceUnit BASE;

    public static ResistanceUnit get(PotentialUnit potentialUnit, CurrentUnit currentUnit) {
        return ResistanceUnit.get(potentialUnit, currentUnit, null, null, null);
    }

    public static ResistanceUnit get(PotentialUnit potentialUnit, CurrentUnit currentUnit, Rational factor, String name, String symbol) {
        ResistanceUnit unit = new ResistanceUnit(potentialUnit, currentUnit, factor, name, symbol);
        return (ResistanceUnit)CACHE.get(unit);
    }

    private ResistanceUnit(PotentialUnit potentialUnit, CurrentUnit currentUnit, Rational factor, String name, String symbol) {
        super(potentialUnit, currentUnit, factor, name, symbol);
    }

    @Override
    public Resistance makeDimension(Number amount) {
        return new Resistance(Rational.get(amount), this);
    }

    public PotentialUnit getPotentialUnit() {
        return (PotentialUnit)this.getLeftUnit();
    }

    public CurrentUnit getCurrentUnit() {
        return (CurrentUnit)this.getRightUnit();
    }

    @Override
    public InductanceUnit times(TimeUnit t) {
        return InductanceUnit.get(this, t);
    }

    static {
        BASE = ohm = ResistanceUnit.get(PotentialUnit.BASE, CurrentUnit.BASE, CoercionConstants.r.postfixBind(1), "Ohm", "\u03a9");
    }
}

