/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import manifold.science.api.AbstractPrimaryUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.AccelerationUnit;
import manifold.science.measures.AngleUnit;
import manifold.science.measures.ChargeUnit;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.FrequencyUnit;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.MetricScaleUnit;
import manifold.science.measures.MomentumUnit;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.Time;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class TimeUnit
extends AbstractPrimaryUnit<Time, TimeUnit>
implements TemporalUnit {
    private static final UnitCache<TimeUnit> CACHE = new UnitCache();
    public static final TimeUnit Femto = TimeUnit.get(MetricScaleUnit.fe.postfixBind(1), Duration.ofNanos(0L), true, false, "Femtosecond", "fs");
    public static final TimeUnit Pico = TimeUnit.get(MetricScaleUnit.p.postfixBind(1), Duration.ofNanos(0L), true, false, "Picosecond", "ps");
    public static final TimeUnit Nano = TimeUnit.get(MetricScaleUnit.n.postfixBind(1), ChronoUnit.NANOS.getDuration(), false, false, "Nanosecond", "ns");
    public static final TimeUnit Micro = TimeUnit.get(MetricScaleUnit.u.postfixBind(1), ChronoUnit.MICROS.getDuration(), false, false, "Microsecond", "\u00b5s");
    public static final TimeUnit Milli = TimeUnit.get(MetricScaleUnit.m.postfixBind(1), ChronoUnit.MILLIS.getDuration(), false, false, "Millisecond", "ms");
    public static final TimeUnit Second = TimeUnit.get(CoercionConstants.r.postfixBind(1), ChronoUnit.SECONDS.getDuration(), false, false, "Second", "s");
    public static final TimeUnit Minute = TimeUnit.get(CoercionConstants.r.postfixBind(60), ChronoUnit.MINUTES.getDuration(), false, false, "Minute", "min");
    public static final TimeUnit Hour = TimeUnit.get(CoercionConstants.r.postfixBind(60).times(60), ChronoUnit.HOURS.getDuration(), false, false, "Hour", "hr");
    public static final TimeUnit Day = TimeUnit.get(CoercionConstants.r.postfixBind(24).times(60).times(60), ChronoUnit.DAYS.getDuration(), true, true, "Day", "day");
    public static final TimeUnit Week = TimeUnit.get(CoercionConstants.r.postfixBind(7).times(24).times(60).times(60), ChronoUnit.WEEKS.getDuration(), true, true, "Week", "wk");
    public static final TimeUnit Month = TimeUnit.get(CoercionConstants.r.postfixBind(31556952).div(12), ChronoUnit.MONTHS.getDuration(), true, true, "Month", "mo");
    public static final TimeUnit Year = TimeUnit.get(CoercionConstants.r.postfixBind(31556952), ChronoUnit.YEARS.getDuration(), true, true, "Year", "yr");
    public static final TimeUnit Decade = TimeUnit.get(CoercionConstants.r.postfixBind(31556952).times(10), ChronoUnit.DECADES.getDuration(), true, true, "Decade", "decade");
    public static final TimeUnit Century = TimeUnit.get(CoercionConstants.r.postfixBind(31556952).times(100), ChronoUnit.CENTURIES.getDuration(), true, true, "Century", "century");
    public static final TimeUnit Millennium = TimeUnit.get(MetricScaleUnit.k.postfixBind(31556952), ChronoUnit.MILLENNIA.getDuration(), true, true, "Millennium", "millennium");
    public static final TimeUnit Era = TimeUnit.get(MetricScaleUnit.G.postfixBind(31556952), ChronoUnit.ERAS.getDuration(), true, true, "Era", "era");
    public static final TimeUnit TrMonth = TimeUnit.get(CoercionConstants.r.postfixBind("31556925.445/12"), Duration.ofSeconds(2629743L, 787080000L), true, true, "Tropical Month", "tmo");
    public static final TimeUnit TrYear = TimeUnit.get(CoercionConstants.r.postfixBind("31556925.445"), Duration.ofSeconds(31556925L, 445000000L), true, true, "Tropical Year", "tyr");
    public static final TimeUnit Planck = TimeUnit.get(CoercionConstants.r.postfixBind("5.39056e-44"), Duration.ofNanos(0L), true, false, "Planck-time", "tP");
    public static final TimeUnit BASE = Second;
    private final Duration _duration;
    private final boolean _fuzzyDuration;
    private final boolean _isDateBased;

    public static TimeUnit get(Rational secondFactor, Duration duration, boolean fuzzyDuration, boolean isDateBased, String name, String symbol) {
        return (TimeUnit)CACHE.get(new TimeUnit(secondFactor, duration, fuzzyDuration, isDateBased, name, symbol));
    }

    private TimeUnit(Rational sec, Duration duration, boolean fuzzyDuration, boolean isDateBase, String name, String symbol) {
        super(sec, name, symbol);
        this._duration = duration;
        this._fuzzyDuration = fuzzyDuration;
        this._isDateBased = isDateBase;
    }

    @Override
    public Time makeDimension(Number amount) {
        return new Time(Rational.get(amount), this);
    }

    public Rational getSeconds() {
        return this.toNumber();
    }

    @Override
    public Duration getDuration() {
        return this._duration;
    }

    @Override
    public boolean isDurationEstimated() {
        return this._fuzzyDuration;
    }

    @Override
    public boolean isDateBased() {
        return this._isDateBased;
    }

    @Override
    public boolean isTimeBased() {
        return !this._isDateBased;
    }

    @Override
    public <R extends Temporal> R addTo(R temporal, long amount) {
        return (R)temporal.plus(amount, this);
    }

    @Override
    public long between(Temporal temporal1Inclusive, Temporal temporal2Exclusive) {
        return temporal1Inclusive.until(temporal2Exclusive, this);
    }

    public LengthUnit times(VelocityUnit v) {
        return v.getLengthUnit();
    }

    public VelocityUnit times(AccelerationUnit acc) {
        return acc.getVelocityUnit();
    }

    public ChargeUnit times(CurrentUnit current) {
        return ChargeUnit.Coulomb;
    }

    public AngleUnit times(FrequencyUnit frequency) {
        return frequency.getAngleUnit();
    }

    public EnergyUnit times(PowerUnit power) {
        return power.getEnergyUnit();
    }

    public MomentumUnit times(ForceUnit force) {
        return force.getMassUnit().times(force.getAccUnit().getVelocityUnit().getLengthUnit().div(this));
    }
}

