/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.dataloader.registries;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import manifold.shade.org.dataloader.DataLoader;
import manifold.shade.org.dataloader.DataLoaderRegistry;
import manifold.shade.org.dataloader.annotations.ExperimentalApi;
import manifold.shade.org.dataloader.impl.Assertions;
import manifold.shade.org.dataloader.registries.DispatchPredicate;

@ExperimentalApi
public class ScheduledDataLoaderRegistry
extends DataLoaderRegistry
implements AutoCloseable {
    private final ScheduledExecutorService scheduledExecutorService;
    private final DispatchPredicate dispatchPredicate;
    private final Duration schedule;
    private volatile boolean closed;

    private ScheduledDataLoaderRegistry(Builder builder) {
        this.dataLoaders.putAll(builder.dataLoaders);
        this.scheduledExecutorService = builder.scheduledExecutorService;
        this.dispatchPredicate = builder.dispatchPredicate;
        this.schedule = builder.schedule;
        this.closed = false;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public Duration getScheduleDuration() {
        return this.schedule;
    }

    @Override
    public void dispatchAll() {
        this.dispatchAllWithCount();
    }

    @Override
    public int dispatchAllWithCount() {
        int sum = 0;
        for (Map.Entry entry : this.dataLoaders.entrySet()) {
            DataLoader dataLoader = (DataLoader)entry.getValue();
            String key = (String)entry.getKey();
            if (this.dispatchPredicate.test(key, dataLoader)) {
                sum += dataLoader.dispatchWithCounts().getKeysCount();
                continue;
            }
            this.reschedule(key, dataLoader);
        }
        return sum;
    }

    public void dispatchAllImmediately() {
        super.dispatchAll();
    }

    public int dispatchAllWithCountImmediately() {
        return super.dispatchAllWithCount();
    }

    public void rescheduleNow() {
        this.dataLoaders.forEach(this::reschedule);
    }

    private void reschedule(String key, DataLoader<?, ?> dataLoader) {
        if (!this.closed) {
            Runnable runThis = () -> this.dispatchOrReschedule(key, dataLoader);
            this.scheduledExecutorService.schedule(runThis, this.schedule.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private void dispatchOrReschedule(String key, DataLoader<?, ?> dataLoader) {
        if (this.dispatchPredicate.test(key, dataLoader)) {
            dataLoader.dispatch();
        } else {
            this.reschedule(key, dataLoader);
        }
    }

    public static Builder newScheduledRegistry() {
        return new Builder();
    }

    public static class Builder {
        private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        private DispatchPredicate dispatchPredicate = (key, dl) -> true;
        private Duration schedule = Duration.ofMillis(10L);
        private final Map<String, DataLoader<?, ?>> dataLoaders = new HashMap();

        public Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.scheduledExecutorService = Assertions.nonNull(executorService);
            return this;
        }

        public Builder schedule(Duration schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder dispatchPredicate(DispatchPredicate dispatchPredicate) {
            this.dispatchPredicate = Assertions.nonNull(dispatchPredicate);
            return this;
        }

        public Builder register(String key, DataLoader<?, ?> dataLoader) {
            this.dataLoaders.put(key, dataLoader);
            return this;
        }

        public Builder registerAll(DataLoaderRegistry otherRegistry) {
            this.dataLoaders.putAll(otherRegistry.getDataLoadersMap());
            return this;
        }

        public ScheduledDataLoaderRegistry build() {
            return new ScheduledDataLoaderRegistry(this);
        }
    }
}

