/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.dataloader.stats;

import manifold.shade.org.dataloader.stats.SimpleStatisticsCollector;
import manifold.shade.org.dataloader.stats.Statistics;
import manifold.shade.org.dataloader.stats.StatisticsCollector;
import manifold.shade.org.dataloader.stats.context.IncrementBatchLoadCountByStatisticsContext;
import manifold.shade.org.dataloader.stats.context.IncrementBatchLoadExceptionCountStatisticsContext;
import manifold.shade.org.dataloader.stats.context.IncrementCacheHitCountStatisticsContext;
import manifold.shade.org.dataloader.stats.context.IncrementLoadCountStatisticsContext;
import manifold.shade.org.dataloader.stats.context.IncrementLoadErrorCountStatisticsContext;

public class ThreadLocalStatisticsCollector
implements StatisticsCollector {
    private static final ThreadLocal<SimpleStatisticsCollector> collector = ThreadLocal.withInitial(SimpleStatisticsCollector::new);
    private final SimpleStatisticsCollector overallCollector = new SimpleStatisticsCollector();

    public ThreadLocalStatisticsCollector resetThread() {
        collector.remove();
        return this;
    }

    @Override
    public <K> long incrementLoadCount(IncrementLoadCountStatisticsContext<K> context) {
        this.overallCollector.incrementLoadCount(context);
        return collector.get().incrementLoadCount(context);
    }

    @Override
    @Deprecated
    public long incrementLoadCount() {
        return this.incrementLoadCount(null);
    }

    @Override
    public <K> long incrementLoadErrorCount(IncrementLoadErrorCountStatisticsContext<K> context) {
        this.overallCollector.incrementLoadErrorCount(context);
        return collector.get().incrementLoadErrorCount(context);
    }

    @Override
    @Deprecated
    public long incrementLoadErrorCount() {
        return this.incrementLoadErrorCount(null);
    }

    @Override
    public <K> long incrementBatchLoadCountBy(long delta, IncrementBatchLoadCountByStatisticsContext<K> context) {
        this.overallCollector.incrementBatchLoadCountBy(delta, context);
        return collector.get().incrementBatchLoadCountBy(delta, context);
    }

    @Override
    @Deprecated
    public long incrementBatchLoadCountBy(long delta) {
        return this.incrementBatchLoadCountBy(delta, null);
    }

    @Override
    public <K> long incrementBatchLoadExceptionCount(IncrementBatchLoadExceptionCountStatisticsContext<K> context) {
        this.overallCollector.incrementBatchLoadExceptionCount(context);
        return collector.get().incrementBatchLoadExceptionCount(context);
    }

    @Override
    @Deprecated
    public long incrementBatchLoadExceptionCount() {
        return this.incrementBatchLoadExceptionCount(null);
    }

    @Override
    public <K> long incrementCacheHitCount(IncrementCacheHitCountStatisticsContext<K> context) {
        this.overallCollector.incrementCacheHitCount(context);
        return collector.get().incrementCacheHitCount(context);
    }

    @Override
    @Deprecated
    public long incrementCacheHitCount() {
        return this.incrementCacheHitCount(null);
    }

    @Override
    public Statistics getStatistics() {
        return collector.get().getStatistics();
    }

    public Statistics getOverallStatistics() {
        return this.overallCollector.getStatistics();
    }

    public String toString() {
        return "ThreadLocalStatisticsCollector{thread=" + this.getStatistics().toString() + "overallCollector=" + this.overallCollector.getStatistics().toString() + '}';
    }
}

