/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.snakeyaml.engine.v1.api.lowlevel;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import manifold.shade.org.snakeyaml.engine.v1.api.DumpSettings;
import manifold.shade.org.snakeyaml.engine.v1.api.lowlevel.Events;
import manifold.shade.org.snakeyaml.engine.v1.events.Event;
import manifold.shade.org.snakeyaml.engine.v1.nodes.Node;
import manifold.shade.org.snakeyaml.engine.v1.serializer.Serializer;

public class Serialize {
    private final DumpSettings settings;

    public Serialize(DumpSettings settings) {
        Objects.requireNonNull(settings, "DumpSettings cannot be null");
        this.settings = settings;
    }

    public List<Event> serializeOne(Node node) {
        Objects.requireNonNull(node, "Node cannot be null");
        return this.serializeAll(Collections.singletonList(node));
    }

    public List<Event> serializeAll(List<Node> nodes) {
        Objects.requireNonNull(nodes, "Nodes cannot be null");
        Events events = new Events();
        Serializer serializer = new Serializer(this.settings, events);
        serializer.open();
        for (Node node : nodes) {
            serializer.serialize(node);
        }
        serializer.close();
        return events.getEvents();
    }
}

