/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.tokenizer;

public class Token {
    private TokenType _type;
    private int _offset;
    private String _value;
    private int _line;
    private int _column;

    Token(TokenType type, int offset, String value, int line, int column) {
        this._type = type;
        this._offset = offset;
        this._value = value;
        this._line = line;
        this._column = column;
    }

    public TokenType getType() {
        return this._type;
    }

    public String getText() {
        return this._value;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getLine() {
        return this._line;
    }

    public int getColumn() {
        return this._column;
    }

    public static enum TokenType {
        CONTENT,
        COMMENT,
        EXPR,
        STMT,
        DIRECTIVE,
        EXPR_BRACE_BEGIN("${"),
        EXPR_BRACE_END("}"),
        EXPR_ANGLE_BEGIN("<%="),
        STMT_ANGLE_BEGIN("<%"),
        DIR_ANGLE_BEGIN("<%@"),
        ANGLE_END("%>"),
        COMMENT_BEGIN("<%--"),
        COMMENT_END("--%>");

        private String _staticToken;

        private TokenType() {
        }

        private TokenType(String staticToken) {
            this._staticToken = staticToken;
        }

        public String getToken() {
            return this._staticToken;
        }
    }
}

